//
// LogListener.c++
//
//	Interface for getting notification when a log message is
//	to be logged.
//
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

#ident "$Revision: 1.4 $"

#include <sysadm/LogListener.h>
#include <sysadm/LogFilter.h>

BEGIN_NAMESPACE(sysadm);

//
// Constructor.
//
LogListener::LogListener()
{
}

//
// Destructor.
//
LogListener::~LogListener()
{
}

//
//  void LogListener::adoptFilter(LogFilter* filter)
//
//  Description:
//      Add a filter for use by testMessage().
//
//  Parameters:
//      filter  The filter to add.
//
void LogListener::adoptFilter(LogFilter* filter)
{
    _filters.add(filter);
}

//
//  void LogListener::removeAllFilters()
//
//  Description:
//      Get rid of all of our filters.  This clears the way for a
//      different set to be added.
//
void LogListener::removeAllFilters()
{
    RemoveAndDestroyContentsOf(&_filters);
}

//
//  bool LogListener::testMessage(const char* module, Log::Level level)
//
//  Description:
//      See if a message with this "module" and "level" should be
//      passed to our handleMessage() method.
//
//  Parameters:
//      module  Module this message is from.
//      level     Log::FATAL .. Log::TRACE
//
//  Returns:
//	true if the message should be logged, false otherwise.
//
bool LogListener::testMessage(const char* module, Log::Level level)
{
    // No filters means we log fatal, errors, warnings, and info messages.
    if (_filters.getSize() == 0) {
	return level & (Log::FATAL | Log::ERROR | Log::WARNING | Log::INFO);
    }

    IteratorOver<LogFilter> iter(&_filters);
    LogFilter* filt;
    while ((filt = iter()) != NULL) {
	if (filt->testMessage(module, level)) {
	    return true;
	}
    }

    return false;
}

END_NAMESPACE(sysadm);
