//
// LogListener.h
//
//	Interface for getting log messages.
//
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

#ifndef _SYSADM_LOG_LISTENER_H
#define _SYSADM_LOG_LISTENER_H
#ident "$Revision: 1.4 $"

#include <stdarg.h>

#include <sysadm/Log.h>
#include <sysadm/CollectionOf.h>

BEGIN_NAMESPACE(sysadm);

class LogFilter;

//
// A LogListener receives messages from Log and logs them
// somewhere.  Separate LogListeners are used by sysadmd for logging
// to syslog and to any other file.  The "log" service uses another
// LogListener that sends log messages to the client.
//
class LogListener {
  public:

    // Constructor.
    LogListener();

    // Destructor.
    virtual ~LogListener();

    // Add a LogFilter.  LogFilters are used by the testMessage()
    // method for determining whether this LogListener should be
    // called for a particular message.  If testMessage() returns
    // false for a message, handleMessage() will not be called for
    // that message.
    //
    // If there are no filters, testMessage() returns true for fatal
    // errors, errors, warnings, and information messages.
    virtual void adoptFilter(LogFilter* filter);

    // Remove all of our filters.  This clears the way for adding a
    // new set of filters.
    virtual void removeAllFilters();

    // Determine whether handleMessage() should be called for a
    // particular message.
    virtual bool testMessage(const char* module, Log::Level level);

    // Log a message.  This usually involves printing it somewhere.
    virtual void handleMessage(const char* module, Log::Level level,
			       const char* format, va_list args) = 0;
  protected:

    CollectionOf<LogFilter> _filters;

  private:

    // Intentionally undefined.
    LogListener(const LogListener&);
    LogListener& operator=(const LogListener&);
};

END_NAMESPACE(sysadm);
#endif  //  _SYSADM_LOG_LISTENER_H
