//
//  Copyright (c) 1995, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

#ifndef _SYSADM_ORDERED_COLLECTION_OF_H
#define _SYSADM_ORDERED_COLLECTION_OF_H

#include <sysadm/CollectionOf.h>

BEGIN_NAMESPACE(sysadm);

// See comments pertaining to all collections in CollectionOf.h

class OrderedCollectionOfImpl;

// Ordered collection is a generic collection in which the order of the
// elements is importent.  Therefore, methods are provided to place the 
// elements reletive to each other  

template <class Type> 
class OrderedCollectionOf : public CollectionOf<Type> 
{
  public:
    inline OrderedCollectionOf();
    inline OrderedCollectionOf( const OrderedCollectionOf& copy );
    
    inline ~OrderedCollectionOf();  

    inline OrderedCollectionOf& operator=( const OrderedCollectionOf& copy );

    inline void  append( Type* element );
    inline void  prepend( Type* element );
    inline void  insertBefore( Type* element, const Type& before );
    inline void  insertAfter( Type* element, const Type& after );


  protected:
    inline OrderedCollectionOf( CollectionOfImpl* adoptedImpl );
};


// Convenience function to remove and delete each object in a
// ordered collection.  It's not a member function of OrderedCollectionOf
// because then OrderedCollection of const objects would not work right.
template <class Type> inline
void RemoveAndDestroyContentsOf( OrderedCollectionOf<Type> *collectionAlias );

END_NAMESPACE(sysadm);

#include <sysadm/OrderedCollectionOfI.h>
#endif  //  _SYSADM_ORDERED_COLLECTION_OF_H
