//
// OrderedFileName.h
//
//	Holds an file name where the name is of the form:
//      <number>.<Name>
//
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

#ifndef _SYSADM_ORDEREDFILENAME_H
#define _SYSADM_ORDEREDFILENAME_H
#ident "$Revision: 1.3 $"

#include <sysadm/OrderedCollectionOf.h>
#include <sysadm/String.h>


BEGIN_NAMESPACE(sysadm);

/**
   Members of this class hold the name of a file, where the format is
   * <numeric order>.<alphanumeric file name>.  For example:
   *
   * 1000.File1
   * 3000.File2
   * File3
   * 3000
   *
   * Members are sorted as follows:
   * If there is no '.' in the file name, consider the <numeric order>
   * field to be empty.  Sort the list by using strcmp on the <numeric
   * order> field, then on the <alphanumeric file name> as a secondary
   * key.
   */
class OrderedFileName {
  private:
    char* _order;
    char* _name;
    char* _fileName;
    char* _fullPath;
    static void addOrderedFileName(OrderedFileName* file,
				   OrderedFileName**& orderedFilesPtr,
				   int fileAlloc,
				   int& numFiles);
    static int compare(const void* te1, const void* te2);
    OrderedFileName(char* fileName, char* fullPath);
    ~OrderedFileName();
  public:

    // Return a sorted array of pointers to OrderedFileNames,
    // constructed from all of the files in a directory.  The array is
    // terminated by a NULL entry.  Use the destroyOrderedFileNameList
    // method to clean up the value returned.  If the directory
    // doesn't exist, then this will return NULL.
    static OrderedFileName** createOrderedFileNamesFromDir(
	const char* dirName);
    
    // Cleans up the sorted array of pointers to OrderedFileNames
    // returned by createOrderedFileNamesFromDir.
    static void destroyOrderedFileNameList(OrderedFileName** list);

    // Gets the order portion of the name
    char * getOrder() {return _order;}

    // Gets the alphanumeric file name portion of the name
    char * getName() {return _name;}

    // Gets the entire filename
    char * getFileName() {return _fileName;}

    // Gets the fully qualified name of the file, starting from /
    char * getFullPath() {return _fullPath;}

    
};

END_NAMESPACE(sysadm);
#endif  //  _SYSADM_ORDEREDFILENAME_H
