/*
 * sysadm.h
 *
 *	Common macros which should be included at the top of all other
 *	sysadm headers.
 *
 *
 *  Copyright (c) 1997, 2000 Silicon Graphics, Inc.  All Rights Reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of version 2.1 of the GNU Lesser General Public
 *  License as published by the Free Software Foundation.
 *  
 *  This program is distributed in the hope that it would be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  
 *  Further, this software is distributed without any warranty that it is
 *  free of the rightful claim of any third person regarding infringement
 *  or the like.  Any license provided herein, whether implied or
 *  otherwise, applies only to this software file.  Patent licenses, if
 *  any, provided herein do not apply to combinations of this program
 *  with other software, or any other product whatsoever.
 *  
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this program; if not, write the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
 *  USA.
 *  
 *  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
 *  Mountain View, CA 94043, or http://www.sgi.com/
 *  
 *  For further information regarding this notice, see:
 *  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
 */

#ifndef _SYSADM_SYSADM_H
#define _SYSADM_SYSADM_H
#ident "$Revision: 1.5 $"

#include <sysadm/config.h>
#include <sysadm/paths.h>


#ifdef __cplusplus
extern "C" {
#endif


/*
 *  Some compilers don't support namespace.
 */
#if HAVE_NAMESPACE
#define BEGIN_NAMESPACE(name) namespace name {
#define END_NAMESPACE(name) }
#define USING_NAMESPACE(name) using namespace name
#define NAMESPACE_SCOPE(name) name::
#else
#define BEGIN_NAMESPACE(name)
#define END_NAMESPACE(name)
#define USING_NAMESPACE(name)
#define NAMESPACE_SCOPE(name)
#endif


/*
 *  Is there a portable C boolean typedef?  SGI's sys/types.h has a boolean_t
 *  which is nonstandard & not present in Linux.  Instead we will use the C++
 *  bool.  I think older SGI C++ compilers do not have bool, so this won't work
 *  for them.
 */
#if (!HAVE_BOOL) || (!defined(__cplusplus))
/* why not #define _BOOL? */
#undef bool
typedef unsigned char bool;
#define false ((bool)0)
#define true ((bool)1)
/*static const bool false = 0;*/
/*static const bool true = 1;*/
#endif /* (!HAVE_BOOL) || (!defined(__cplusplus)) */


/*
 *  This is a bad replacement for sginap.  Better to not use it.
 */
#ifndef HAVE_SGINAP
#define sginap(t) (t ? sleep(t / 100) : 0)
#endif  /* !HAVE_SGINAP */


#ifdef __cplusplus
}
#endif

#endif /* _SYSADM_SYSADM_H */
