//
// testAttrBundle.c++
//
//	Test code for AttrBundle class.
//
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2 of the GNU General Public License as
//  published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307, USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

#ident "$Revision: 1.9 $"

#include <iostream.h>

#include <sysadm/AttrBundle.h>

using namespace sysadm;

class TestListener : public AttrListener {
  public:
    void attrChanged(const AttrEvent& event) {
	const Attribute& attr(event.getChangedAttr());
	cout << "changed: " << attr.getKey() << ": " <<
	    attr.getValueString() << endl;
    }
};

void main()
{
    AttrBundle bundle("type", "selector");
    bundle.setAttr(Attribute("name", "rogerc"));
    bundle.setAttr(Attribute("uid", 3099LL));
    bundle.setAttr(Attribute("male", true));
    bundle.setAttr(Attribute("weight", 195.5));
    bundle.setAttr(Attribute("exempt", Attribute::BOOLEAN, "false"));
    bundle.setAttr(Attribute(":passwd:", "secret"));
    bundle.setAttrVisible(":passwd:", false);

    cout << bundle.toString() << endl;

    AttrBundle bundle2(bundle.serialize());

    cout << bundle2.toString() << endl;

    cout << bundle.serialize() << endl;
    cout << bundle2.serialize() << endl;

    AttrBundle* copy = bundle.clone();

    cout << copy->toString() << endl;
    copy->setAttr(Attribute("son", "Kyle"));
    cout << copy->toString() << endl;
    delete copy;
    cout << bundle.toString() << endl;

    bundle.setAttr(Attribute("recursive", bundle));
    cout << bundle.toString() << endl;
    cout << AttrBundle(bundle.serialize()).toString() << endl;

    AttrBundle noattrs("type", "selector");
    cout << noattrs.toString() << endl;

    cout << AttrBundle(noattrs.serialize()).toString() << endl;

    AttrBundle emptyAttr("type", "emptyAttr");
    emptyAttr.setAttr(Attribute("name", ""));
    emptyAttr.setAttr(Attribute("", ""));
    cout << emptyAttr.toString() << endl;
    cout << AttrBundle(emptyAttr.serialize()).toString() << endl;

    AttrBundle empty("", "");
    cout << empty.toString() << endl;
    cout << AttrBundle(empty.serialize()).toString() << endl;

    AttrBundle escape("\n@!:=", "\n@!:=");
    escape.setAttr(Attribute("\n@!:=", "\n@!:="));
    cout << escape.toString() << endl;
    cout << AttrBundle(escape.serialize()).toString() << endl;

    AttrBundle notify("test", "notify");
    AttrListener* listener = new TestListener;
    notify.adoptAttrListener(listener);
    notify.setAttr(Attribute("test", 50LL));
    notify.setAttr(Attribute("test", 51LL));
    notify.setAttr(Attribute("test", 51LL)); 
    notify.setAttr(Attribute("name", "rogerc"));
    notify.setAttr(Attribute("name", "rogerc"));
    notify.setAttr(Attribute("male", true));
    notify.setAttr(Attribute("weight", 195.5));
    notify.setAttr(Attribute("male", true));
    notify.setAttr(Attribute("weight", 195.5));
    notify.setAttr(Attribute("weight", 192.5));
    notify.removeAttrListener(listener);

    if (!notify.equals(notify))
	cout << "Has Changed" << endl;
    else
	cout << "Has Not Changed" << endl;

    AttrBundle changed(notify);
    changed.setAttr(Attribute("weight", 112.5));

    if (!notify.equals(changed))
	cout << "Has Changed" << endl;
    else
	cout << "Has Not Changed" << endl;

    Attribute attr = Attribute("age", (long long)32);
    cout << attr.getKey() << " = " << attr.getValueString() << " ("
	 << attr.getTypeString() << ")\n";

    // Test assignment operator
    attr = Attribute("name", "Roger");
    cout << attr.getKey() << " = " << attr.getValueString() << " ("
	 << attr.getTypeString() << ")\n";

    attr = Attribute("female", false);
    cout << attr.getKey() << " = " << attr.getValueString() << " ("
	 << attr.getTypeString() << ")\n";
}
