// Test file for streams.
//
//  Copyright (c) 1995, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2 of the GNU General Public License as
//  published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307, USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//


#include <stdlib.h>
#include <sysadm/String.h>

using namespace sysadm;

void
main()
{
    // create from char*
    String s1("string 1");
    if (s1 == "string 1") {
	cout << "passed";
    } else {
	cout << "** FAILED";
    }
    cout << ": String from char*: " << s1 << endl;

    // create from another string
    String s2(s1);
    String s3(s1);
    const char* p1 = s1;
    const char* p2 = s2;
    const char* p3 = s3;
    if (p1 == p2 && p1 == p3) {
	cout << "passed";
    } else {
	cout << "** FAILED";
    }
    cout << ": String from String&: " << s2 << endl;
    
    // unshare it
    s1 += " copy";
    p1 = s1;
    p2 = s2;
    p3 = s3;
    if (p1 != p2 && p2 == p3) {
	cout << "passed";
    } else {
	cout << "** FAILED";
    }
    cout << ": Copy on write of " << s2 << " from " << s1 << endl;
    

    // unshare it
    s2 += " copy 2";
    p2 = s2;
    p3 = s3;
    if (p1 != p2) {
	cout << "passed";
    } else {
	cout << "** FAILED";
    }
    cout << ": Copy on write of " << s2 << " from " << s3 << endl;
    


    // init from assignment
    String s4 = s3;
    const char* p4 = s4;
    if (p4 == p3) {
	cout << "passed";
    } else {
	cout << "** FAILED";
    }
    cout << ": Assignment init of " << s4 << " from " << s1 << endl;

    // dirty cast
    String s5(s1);
    const char* p5 = s5;
    char* dirty = s1.writableCharPtr();
    if (dirty != p5) {
	cout << "passed";
    } else {
	cout << "** FAILED";
    }
    cout << ": Dirty cast of: " << s1 << endl;

    // dirty char& cast
    s5 = s1;
    p5 = s5;
    s1[(CharIndex)0] = 'X';
    p1 = s1;
    if (p1 != p5) {
	cout << "passed";
    } else {
	cout << "** FAILED";
    }
    cout << ": Dirty char& cast of: " << s1 << endl;

    // plus operator
    s1 = "string 1/";
    s2 = "string 2";
    p1 = s1;
    p2 = s2;
    String s6 = s1 + s2;
    if (p1 == s1 && p2 == s2) {
	cout << "passed";
    } else {
	cout << "** FAILED";
    }
    cout << ": add " << s1 << " and " << s2 << " giving " << s6 << endl;
	
    // plus= operator
    String s7("string 7");
    const char* p7 = s7;
    s7 += " suffix";
    if (p7 != s7) {
	cout << "passed";
    } else {
	cout << "** FAILED";
    }
    cout << ": += giving " << s7 << endl;
	
    exit(0);
}
