//
// ItemTestResult.java
//
//	A class that contains the results of testing an item with an ItemTester
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//
package com.sgi.sysadm.category;

import com.sgi.sysadm.util.*;

/**
 * A class that contains the results of testing an Item with an
 * ItemTester.
 *
 * @see com.sgi.sysadm.category.ItemTester
 */
public class ItemTestResult {
    
    private boolean _passed;
    private Object _reason;
    
    /**
     * A static object that represents a successful test.
     */
    public static final ItemTestResult TEST_PASSED =
        new ItemTestResult(true, null);

    /**
     * A static object that represents a failed test.
     */
    public static final ItemTestResult TEST_FAILED =
        new ItemTestResult(false, null);
    
    /** 
     * The constructor.  It's private because we want people to use
     * either the constuctor that takes a reason or the TEST_PASSED
     * constant.
     *
     * @param passed True if the Item passed the test, else false.
     * @param reason An object representing the reason the item didn't
     *               pass the test
     */
    private ItemTestResult(boolean passed, Object reason) {
	
	_passed = passed;
	_reason = reason;
    }

    /**
     * The constuctor.  Creates a result specifying that the item
     * didn't pass the test and takes an Object representing the
     * reason.  If you want to return a successful result, use the
     * TEST_PASSED constant.
     *
     * @param reason An object representing the reason the item didn't
     *               pass the test
     */
    public ItemTestResult(Object reason) {
	this(false, reason);
    }

    /**
     * Returns a boolean that tells if the Item passed the test.
     */
    public boolean passed() {
	return _passed;
    }
    
    /** 
     * Returns an Object representing the reason the item didn't
     * pass the test
     */
    public Object reason() {
	Log.assert(!_passed, "Can't ask for reason if the test succeeded");
	return _reason;
    }
}
