//
// SelectorItemTester.java
//
//	Simple ItemTester implementation which tests Items by their
//	selectors.
//
//
//  Copyright (c) 1999, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

package com.sgi.sysadm.category;

import com.sgi.sysadm.util.Log;

/**
 * This is a simple ItemTester which tests Items by comparing their
 * selectors.
 */
public class SelectorItemTester implements ItemTester {

    private String selector;

    /**
     * Creates a SelectorItemTester which will compare Items to the given
     * selector. 
     * 
     * @param selector String to compare to Items' selectors.  Must not be null.
     */
    public SelectorItemTester(String selector) {
	Log.assert(selector != null, "selector is null");
	this.selector = selector;
    }

    /**
     * Determine whether the Item's selector matches this SelectorItemTester's
     * selector.
     * 
     * @param item Item to be tested.
     * 
     * @return ItemTestResult.TEST_PASSED or ItemTestResult.TEST_FAILED.
     */
    public ItemTestResult testItem(Item item) {
	if ((item != null) && (item.getSelector().equals(selector))) {
	    return ItemTestResult.TEST_PASSED;
	}
	return ItemTestResult.TEST_FAILED;
    }
}
