//
// Packet.java
//
//	Unit of communication over a Connection.
//
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

package com.sgi.sysadm.comm;

import com.sgi.sysadm.util.AttrBundle;

/**
 * Packet is the unit of communication when using a Connection.  A
 * packet has a type, which represents a service, and a selector,
 * which represents an operation within that service.  Most
 * information in a packet is contained in typed/key value pairs,
 * which Packet inherits from AttrBundle.
 * <p>
 * A Packet can be used to send and receive arbitrary data using the
 * setData() and getData() methods.  A packet that has data associated
 * with it via setData() cannot be transmitted across the network in a
 * byte-order independent manner, however, so this facility should
 * only be used when the data being transported can be interpreted
 * independently of byte-order.
 */
public class Packet extends AttrBundle {

    private byte[] _data = null;
    int _dataLength = 0;

    /**
     * Packet constructor.
     * 
     * @param type Type of this packet.  This is used to indicate
     *             which service this packet is part of.
     * @param selector Selector of this packet.  This is used to
     *                 select an operation or return code within the
     *                 context of a service.
     */
    public Packet(String type, String selector) {
	super(type, selector);
    }

    /**
     * Packet constructor.  This constructor gets the type, selector,
     * and Attributes of this packet from the string-ified
     * representation <TT>stream</TT>.
     * 
     * @param stream String-ified packet.
     */
    public Packet(String stream) {
	super(stream);
    }

    /**
     * Packet constructor.  This constructor gets type, selector, and
     * Attributes from an AttrBundle.
     * 
     * @param attrs AttrBundle containing this Packet's Attributes.
     */
    public Packet(AttrBundle attrs) {
	super(attrs);
    }

    /**
     * Set the data for this packet.
     * 
     * @param data The data for this packet.
     * @param dataLength The length of the data for this packet.
     */
    public void setData(byte[] data, int dataLength) {
	_data = data;
	_dataLength = dataLength;
    }

    /**
     * Get the data for this packet.
     * 
     * @return The data for this packet.
     */
    public byte[] getData() {
	return _data;
    }

    /**
     * Get the length of the data for this packet.
     * 
     * @return The length of the data for this packet.
     */
    public int getDataLength() {
	return _dataLength;
    }
}
