//
// ServerConnectionFactory.java
//
//	Creates Connection for the client to use to communicate with
//	the server.
//
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

package com.sgi.sysadm.comm;

import java.io.*;
import java.util.*;
import com.sgi.sysadm.util.*;

/**
 * Interface for creating a Connection to a server.  Subclasses of
 * ServerConnectionFactory implement a specific protocol for
 * connecting to a server.
 */
public interface ServerConnectionFactory {
    /**
     * Create a Connection for this factory.  This can be called at any
     * time, which means that subclasses must be able to create a
     * Connection without throwing any exceptions.
     * 
     * @return Connection maintained by this factory.
     */
    public abstract Connection createConnection();

    /**
     * Connect to a server.  It is valid to pass the same Connection
     * to connect multiple times with different values of
     * <tt>arg</tt>.  This would result in disconnecting from the
     * previous server and connecting to the new server.
     * <p>
     * It is an error to pass a <tt>conn<\tt> argument that was not
     * created by a call to createConnection().
     * 
     * @param arg Protocol-specific connection argument.
     * @param listener Gets informed of the result of the connection
     *                 attempt.
     */
    public abstract void connect(Connection conn, Object arg,
				 ResultListener listener);

    /**
     * Cancel connection attempt and return failure.
     */
    public abstract void cancelConnection();

}
