//
// SocketConnection.java
//
//	ByteStreamConnection that uses a Socket.
//
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

package com.sgi.sysadm.comm;

import java.io.*;
import java.net.*;

/**
 * SocketConnection is a ByteStreamConnection that reads from a
 * Socket's InputStream and writes to its OutputStream.
 */
public class SocketConnection extends ByteStreamConnection {
    Socket _sock = null;

    /**
     * SocketConnection constructor.
     */
    public SocketConnection() {
    }

    /**
     * Set the Socket to be used for this Connection.
     * 
     * @param sock The socket to be used for sending and receiving packets.
     * 
     * @exception IOException if an I/O error occurs.
     */
    public void setSocket(Socket sock) throws IOException {
	_sock = sock;
	setInputStream(sock.getInputStream());
	setOutputStream(sock.getOutputStream());
    }

    /**
     * Close this connection.  Packets can no longer be sent or
     * received using this connection.
     */
    public void close() {
	super.close();
	if (_sock != null) {
	    try {
		_sock.close();
	    } catch (Exception e) {
	    }
	    _sock = null;
	}
    }

    /**
     * Get the name of our peer.
     * 
     * @return The name of the peer for this Connection.
     */
    public String getRemoteHostName() {
	String hostName = super.getRemoteHostName();

	if (hostName == null || hostName.length() == 0) {
	    hostName = _sock.getInetAddress().getHostName();
	}
	return hostName;
    }
}
