//
// FinalizerElem.java
//
//	Workaround deadlock bug in java.
//
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

package com.sgi.sysadm.manager;

import sun.awt.*;

/**
 * This is an attempt to workaround bug 647274.  My analysis of
 * this bug is that the finalizer thread is stuck trying to enter
 * a monitor in java.lang.Class, so that it can load the
 * AWTFinalizer class.  The owner of the monitor is the event
 * queue thread, which has requested garbage collection and is
 * waiting for it to finish.
 *
 * The main evidence for my theory is that the dump in bug 647274
 * does not show the AWT-Finalizer thread; it hasn't been created
 * yet.  Therefore, to workaround the problem, we call an
 * AWTFinalizer method to ge the class loaded early.
 *
 * This used to be an anonymous class inside RApp, but that caused a
 * SecurityException trying to load the RApp class from an Applet.
 * Putting this code which relies on the forbidden (to Applets)
 * sun.awt code into a separate class causes the SecurityException to
 * happen within a try block in RApp.java.
 */
class FinalizerElem implements AWTFinalizeable {
    AWTFinalizeable _next;
    static void workAroundAWTFinalizerHang() {
	AWTFinalizer.addFinalizeable(new FinalizerElem());
    }
    public void doFinalization() {
    }
    public void setNextFinalizeable(AWTFinalizeable next) {
	_next = next;
    }
    public AWTFinalizeable getNextFinalizeable() {
	return _next;
    }
}
