//
// HostPanelListener.java
//
//	interface for getting HostPanelEvents from a HostPanel.
//
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

package com.sgi.sysadm.manager.login;

import java.util.*;

/**
 * HostPanelListener receives HostPanelEvents from HostPanel.
 */
public interface HostPanelListener extends EventListener {

    /**
     * Called when a Connection has been established.  A HostContext
     * representing the Connection can be retrieved by calling
     * HostPanelEvent.getHostContext().
     * 
     * @param event HostPanelEvent.
     */
    public void hostConnectionSucceeded(HostPanelEvent event);

    /**
     * Called when a protocol error occurs with the server.  The
     * application should display a fatal error dialog.
     * 
     * @param event HostPanelEvent.  Call getConnectionEvent() to get
     *              more detail about the error that occurred.
     */
    public void hostConnectionError(HostPanelEvent event);

    /**
     * HostPanel request that its enclosing Frame or Dialog be
     * displayed.
     * 
     * @param event HostPanelEvent.
     */
    public void hostPanelShow(HostPanelEvent event);

    /**
     * HostPanel request that its enclosing Frame or Dialog be
     * hidden.
     * 
     * @param event HostPanelEvent.
     */
    public void hostPanelHide(HostPanelEvent event);

    /**
     * Called when the user presses the Help button.
     * 
     * @param event HostPanelEvent.
     */
    public void hostPanelHelp(HostPanelEvent event);

    /**
     * Called when the user presses the Cancel button.  The
     * application should exit.
     * 
     * @param event HostPanelEvent.
     */
    public void hostPanelCancel(HostPanelEvent event);
}
