//
// TaskManagerPanel.java
//
//	Interface for panels that can be displayed within TaskManager.
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

package com.sgi.sysadm.manager.taskManager;

import com.sgi.sysadm.util.*;

/**
 * TaskManagerPanel is the interface that must be implemented by objects that
 * want to be displayed in the DisplayArea of the TaskManager window.
 */
public interface TaskManagerPanel extends TaskManagerPlugin {
    /**
     * Get the JPanel to display on the right hand side of TaskManager.
     *
     * @param listener Listener to be notified when panel is ready for
     *                 display.  The ResultEvent result will be the JPanel.
     *
     * @return The JPanel to display.
     */
    public void taskManagerGetPanel(ResultListener listener);

    /**
     * Tell the panel about the DisplayArea.  TaskManagerPanels must
     * call <TT>displayArea</TT>.revalidate() to get redrawn if their
     * contents changes after taskManagerGetPanel() is called.
     *
     * @param displayArea The DisplayArea in which this panel will be
     *                    displayed.
     */
    public void taskManagerSetDisplayArea(DisplayArea displayArea);
}
