//
// TaskManagerProperties.java
//
//	Interface that contains all of the properties used to
//	customize the TaskManager.
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

package com.sgi.sysadm.manager.taskManager;

/**
 * TaskManagerProperties is an interface that contains all of the
 * properties used to customize the TaskManager and its supporting
 * classes.  Classes can refer to these properties without having to
 * fully qualify the names by implementing this interface.
 * <P>
 * The default values for the properties contained here are defined in
 * com.sgi.sysadm.manager.TaskManagerP.properties and may be
 * overridden by the PackageP.properties file(s) of the product or,
 * more typically, in the {package}.TaskManagerP.properties file.  See
 * the TaskManager documentation for more details.
 *
 * @see com.sgi.sysadm.manager.TaskManager
 */
public interface TaskManagerProperties {

    /**
     * The property <I>TaskManager.width</I> is an integer that
     * defines the width, in <A HREF="glossary.html#Point">points</A>,
     * of the TaskManager window when it is first launched.
     */
    static public final String WIDTH = "TaskManager.width";

    /**
     * The property <I>TaskManager.height</I> is an integer that
     * defines the height, in <A HREF="glossary.html#Point">points</A>,
     * of the TaskManager window when it is first launched.
     */
    static public final String HEIGHT = "TaskManager.height";

    /**
     * The property <I>TaskManager.dividerWidth</I> is an integer that
     * defines the width of the divider, in <A
     * HREF="glossary.html#Point">points</A>, that goes between
     * the TaskManager table of contents (left hand side) and the
     * TaskManager display area (right hand side).
     */
    static public final String DIVIDER_WIDTH = "TaskManager.dividerWidth";

    /**
     * The property <I>TaskManager.splitRatio</I> is double that
     * defines the position of the divider, as a decimal fraction of the
     * width of the TaskManager window, that goes between the
     * TaskManager table of contents (left hand side) and the
     * TaskManager display area (right hand side).  For example, to
     * position the divider thirty percent of the way from the left
     * side of the TaskManager window, set the SPLIT_RATIO property as
     * follows:
     * <PRE>
     *      TaskManager.splitRatio = .30
     * </PRE>
     */
    static public final String SPLIT_RATIO =
	"TaskManager.splitRatio";

    /**
     * The property set <I>TaskManager.ProductAttributes&lt;n&gt;</I>
     * is a string array that specifies the products from which
     * <A HREF="glossary.html#ProductAttributes">product
     * attributes</A> will be requested. Any product attributes set by
     * the User will be stored in the HostContext that is passed to Tasks,
     * Metatasks, and plugins launched by TaskManager.  Each product
     * must be given its own property name with
     * <I>TaskManager.ProductAttributes</I> as the base.  For example,
     * a TaskManager that wants to load the product attributes from
     * two different products would describe them in the
     * <I>{package}.TaskManagerP.properties</I> file as follows:
     * <PRE>
     *         TaskManager.ProductAttributes0 = com.sgi.product0
     *         TaskManager.ProductAttributes1 = com.sgi.product1
     * </PRE>
     */
    static public final String PRODUCT_ATTRIBUTES =
				    "TaskManager.ProductAttributes";

    /**
     * The property set <I>TaskManager.initPlugins&lt;n&gt;</I> is a
     * string array that specified the TaskManagerInitPlugins to load
     * when the TaskManager is instantiated.
     */
    static public final String INIT_PLUGINS = "TaskManager.initPlugins";

    /**
     * The property set <I>TaskManager.buttonItem&lt;n&gt;</I>
     * defines the labels to use for the product-specific buttons to
     * add to the bottom of the TaskManager window.  Each buttonItem
     * label must be accompanied by a buttonItem target that describes
     * the TaskManagerAction or TaskManagerFrame to load when the
     * button is pressed.  The name of the button will also be used to
     * create a menu item in the Options menu.  For example:
     * <PRE>
     *       TaskManager.buttonItem0 = "Launch CoolView"
     *       TaskManager.buttonItem0.mnemonic = "C"
     *       TaskManager.buttonItem0.target = com.sgi.cv.CoolViewPlugin
     *       TaskManager.buttonItem1 = "Options"
     *       TaskManager.buttonItem1.mnemonic = "O"
     *       TaskManager.buttonItem1.target = com.sgi.cv.OptionsDialog
     * </PRE>
     */
    static public final String BUTTON_ITEM = "TaskManager.buttonItem";

    /**
     * The String <I>.target</I>, when appended to BUTTON_ITEM,
     * becomes a property that describes the class name to load when
     * the button is pressed.
     *
     * @see com.sgi.sysadm.manager.taskManager.TaskManagerProperties#BUTTON_ITEM
     */
    static public final String BUTTON_TARGET = ".target";

    /**
     * The String <I>.mnemonic</I>, when appended to BUTTON_ITEM,
     * becomes a property that describes the mnemonic of the menu item
     * which will appear in the Options menu.
     *
     * @see com.sgi.sysadm.manager.taskManager.TaskManagerProperties#BUTTON_ITEM
     */
    static public final String MENU_MNEMONIC = ".mnemonic";

    /**
     * The property <I>TaskManager.buttonSpacing</I> is an integer
     * which defines the amount of space, in <A
     * HREF="glossary.html#Point">points</A>, between the
     * buttons at the bottom of the TaskManager window.
     */
    static public final String BUTTON_SPACING =
	"TaskManager.buttonSpacing";

    /**
     * The property <I>TaskManager.marginTop</I> defines the amount of
     * space, in <A HREF="glossary.html#Point">points</A>, between the
     * top of the TaskManager window and the top of the table of
     * contents (left hand side) and display area (right hand side).
     */
    static public final String MARGIN_TOP = "TaskManager.marginTop";

    /**
     * The property <I>TaskManager.marginLeft</I> defines the amount of
     * space, in <A HREF="glossary.html#Point">points</A>, between the
     * left side of the TaskManager window and the left edge of the
     * table of contents.
     */
    static public final String MARGIN_LEFT = "TaskManager.marginLeft";

    /**
     * The property <I>TaskManager.marginBottom</I> defines the amount of
     * space, in <A HREF="glossary.html#Point">points</A>, between the
     * top of the TaskManager button area and
     * the bottom of the table of contents (left hand side) and display
     * area (right hand side).
     */
    static public final String MARGIN_BOTTOM =
	"TaskManager.marginBottom";

    /**
     * The property <I>TaskManager.marginRight</I> defines the amount of
     * space, in <A HREF="glossary.html#Point">points</A>, between the
     * right side of the TaskManager
     * window and the right edge of the display area.
     */
    static public final String MARGIN_RIGHT =
	"TaskManager.marginRight";

    /**
     * The property <I>TaskManager.dialogTitle</I> is the string to
     * display in the title bar of any dialogs that are posted by
     * TaskManager.
     */
    static public final String DIALOG_TITLE =
	"TaskManager.dialogTitle";

    /**
     * The property <I>TaskManager.frameTitle</I> is a format string
     * to display in the title bar of the TaskManager window.
     * Parameter {0} is filled in with the server name from
     * HostContext.  If your product wants the TaskManager window
     * title to be dynamic (e.g. displaying current server
     * information), then it should define a TaskManagerTitleRenderer
     * and use the TITLE_RENDERER property to install the renderer
     * into TaskManager.
     */
    static public final String FRAME_TITLE = "TaskManager.frameTitle";

    /**
     * The property <I>TaskManager.titleRenderer</I> is the name of a
     * TaskManagerTitleRenderer class that should be loaded to
     * maintain the TaskManager window title.  If this property is
     * defined and the specified TaskManagerTitleRenderer exists, the
     * FRAME_TITLE property will be ignored.
     */
    static public final String TITLE_RENDERER =
	"TaskManager.titleRenderer";

    /**
     * The property <I>TaskManager.closeButtonLabel</I> is a string
     * that will be displayed on the right-most button at the bottom
     * of the TaskManager window.  When this button is pressed by the
     * user, the TaskManager window is closed.
     */
    static public final String CLOSE_BUTTON_LABEL =
				    "TaskManager.closeButtonLabel";

    /**
     * The property <I>TaskManager.TOC.activeIcon</I> is the
     * <A HREF="glossary.html#CLASSPATHRelative">CLASSPATH
     * relative</A> name of an <A
     * HREF="glossary.html#IconImageFile">icon image file</A> of the
     * icon to use for the selected Table of Contents entry in
     * TaskManager.  When a user chooses a page link on the left-hand
     * side of the TaskManager window, this icon will be displayed next to the
     * selected entry.
     */
    static public final String TOC_ACTIVE_ICON =
	"TaskManager.TOC.activeIcon";

    /**
     * The property <I>TaskManager.TOC.inactiveIcon</I> is the
     * <A HREF="glossary.html#CLASSPATHRelative">CLASSPATH
     * relative</A> name of an <A
     * HREF="glossary.html#IconImageFile">icon image file</A> of the
     * icon to use for all of the
     * unselected Table of Contents entries in the TaskManager.  When a
     * user chooses a page link on the left-hand side of the
     * TaskManager window, all of the other items will have this icon
     * displayed next to them to indicate that they are not currently
     * active.
     */
    static public final String TOC_INACTIVE_ICON =
				    "TaskManager.TOC.inactiveIcon";

    /**
     * The property <I>TaskManager.TOC.background</I> is the color to
     * use as the background for the TaskManager Table of Contents,
     * which is the column on the left-hand side of the TaskManager
     * window.  The foreground of the Table of Contents is set on the
     * individual components: TOC_TITLE_COLOR and TOC_LINK.
     */
    static public final String TOC_BACKGROUND =
	"TaskManager.TOC.background";

    /**
     * The property <I>TaskManager.TOC.extraVerticalSpace</I> is the
     * vertical distance, in <A HREF="glossary.html#Point">points</A>,
     * between categories in the Table of Contents.
     */
    static public final String TOC_EXTRA_VERTICAL_SPACE =
				    "TaskManager.TOC.extraVerticalSpace";

    /**
     * The property <I>TaskManager.TOC.marginTop</I> is the distance,
     * in <A HREF="glossary.html#Point">points</A>, between the top of
     * the Table of Contents
     * panel and the top of the contents of that panel.
     */
    static public final String TOC_MARGIN_TOP = "TaskManager.TOC.marginTop";

    /**
     * The property <I>TaskManager.TOC.marginLeft</I> is the distance,
     * in <A HREF="glossary.html#Point">points</A>, between the left
     * side of the Table of Contents
     * panel and its contents.
     */
    static public final String TOC_MARGIN_LEFT = "TaskManager.TOC.marginLeft";

    /**
     * The property <I>TaskManager.TOC.marginBottom</I> is the distance,
     * in <A HREF="glossary.html#Point">points</A>, between the bottom
     * of the Table of Contents
     * panel and its contents.
     */
    static public final String TOC_MARGIN_BOTTOM =
				    "TaskManager.TOC.marginBottom";

    /**
     * The property <I>TaskManager.TOC.marginRight</I> is the distance,
     * in <A HREF="glossary.html#Point">points</A>, between the right
     * side of the Table of Contents
     * panel and its contents.
     */
    static public final String TOC_MARGIN_RIGHT =
	"TaskManager.TOC.marginRight";

    /**
     * The property <I>TaskManager.TOC.title</I> is a string that will
     * appear at the top of the Table of Contents.
     */
    static public final String TOC_TITLE = "TaskManager.TOC.title";

    /**
     * The property <I>TaskManager.TOC.title.color</I> is the
     * foreground  color that will be used for the Table of Contents
     * title.
     */
    static public final String TOC_TITLE_COLOR =
	"TaskManager.TOC.title.color";

    /**
     * The string <I>TaskManager.TOCLink</I> is used as the name of
     * the RichTextComponent for each page link that appears in the
     * Table of Contents.
     * This name is used as the prefix for looking up
     * properties for the page links.
     *
     * @see com.sgi.sysadm.ui.richText.RichTextComponent
     */
    static public final String TOC_LINK = "TaskManager.TOCLink";

    /**
     * The property set <I>TaskManager.TOC.item&lt;n&gt;</I> is the
     * list of items that will be displayed in the Table of Contents.
     * Each item is described by its type, which is one of:
     * TaskManagerProperties.TEXT, TaskManagerProperties.TASKLIST,
     * TaskManagerProperties.SEPARATOR, or
     * TaskManagerProperties.CLASS.  Each non-separator item has
     * associated with it a title (see
     * TaskManagerProperties.TOC_ITEM_TITLE) and a target (See
     * TaskManagerProperties.TOC_ITEM_TARGET).
     *
     * For example, if TaskManager is to display a page named
     * "Overview" which is simple text, a page named "Search" that
     * allows the user to search the list of available tasks, a
     * separator, and then tasklist page called "First Page",
     * the properties in {product}.TaskManagerP.properties would look
     * like:
     * <PRE>
     *     TaskManager.TOC.item0 = text
     *     TaskManager.TOC.item0.title = Overview
     *     TaskManager.TOC.item0.target = \
     *            Here is some overview text to display.  It uses \
     *            the subset of HTML supported by RichTextComponent.
     *
     *     TaskManager.TOC.item1 = class
     *     TaskManager.TOC.item1.title = Search
     *     TaskManager.TOC.item1.target =\
     *            com.sgi.sysadm.manager.taskManager.SearchPanel
     *
     *     TaskManager.TOC.item2 = separator
     *
     *     TaskManager.TOC.item3 = tasklist
     *     TaskManager.TOC.item3.title = First Page
     *     TaskManager.TOC.item3.target = FirstPage
     * </PRE>
     * Tasklist pages have two additional property sets
     * associated with them TaskManagerProperties.TASK_GROUP and
     * TaskManagerProperties.METATASK_ITEM, which are described below.
     *
     */
    static public final String TOC_ITEMS = "TaskManager.TOC.item";

    /**
     * If a Table of Contents item has the type <I>text</I>, it will
     * display RichText in the DisplayArea of the TaskManager window.
     * The text is specified as the item target.  See
     * TaskManagerProperties.TOC_ITEMS for details.
     */
    static public final String TEXT = "text";

    /**
     * If a Table of Contents item has the type <I>separator</I>, it
     * will be displayed as a horizontal separator at that location in
     * the Table of Contents.
     */
    static public final String SEPARATOR = "separator";

    /**
     * If a Table of Contents item has the type <I>tasklist</I>, it
     * will display a tasklist page, which is a list of Metatasks
     * followed by a set of Task groups, in the DisplayArea of the
     * TaskManager window.  The item target is a string that is used
     * to form the Metatask and Task group property sets.  For
     * example:
     * <PRE>
     *     TaskManager.TOC.item3 = tasklist
     *     TaskManager.TOC.item3.title = First Page
     *     TaskManager.TOC.item3.target = FirstPage
     *
     *     TaskManager.FirstPage.metataskItem0 = \
     *          com.sgi.product.metatask.FirstMetatask
     *     ...
     *     TaskManager.FirstPage.taskGroup0 = FirstTaskGroup
     * </PRE>
     * See TaskManagerProperties.METATASK_ITEM and
     * TaskManagerProperties.TASK_GROUP for details.
     */
    static public final String TASKLIST = "tasklist";

    /**
     * If a Table of Contents item has the type <I>class</I>, it will
     * display a TaskManagerPanel plugin in the DisplayArea of the
     * TaskManager window.  The target of the item is the class name
     * of the TaskManagerPlugin to load.  For example, the Search
     * feature provided by the sysadm infrastructure would be added to
     * TaskManager as follows:
     * <PRE>
     *     TaskManager.TOC.item1 = class
     *     TaskManager.TOC.item1.title = Search
     *     TaskManager.TOC.item1.target =\
     *            com.sgi.sysadm.manager.taskManager.SearchPanel
     * </PRE>
     */
    static public final String CLASS = "class";

    /**
     * The string <I>.title</I> is appended to
     * TaskManager.TOC.item&lt;n&gt; to determine the title to display
     * for each Table of Contents item.  See
     * TaskManagerProperties.TOC_ITEMS for details.
     */
    static public final String TOC_ITEM_TITLE = ".title";

    /**
     * The string <I>.target</I> is appended to
     * TaskManager.TOC.item&lt;n&gt; to determine the target of each
     * Table of Contents item.  See
     * TaskManagerProperties.TOC_ITEMS for details.
     */
    static public final String TOC_ITEM_TARGET = ".target";

    /**
     * The string <I>.metataskItem</I> is used to form the property
     * set for a list of Metatasks to include in a tasklist page.
     * Each item describes a properties file that contains Metatask
     * data such as the Metatask name icon to display in the
     * DisplayArea.  For example:
     * <PRE>
     *     TaskManager.TOC.item3 = tasklist
     *     TaskManager.TOC.item3.title = First Page
     *     TaskManager.TOC.item3.target = FirstPage
     *
     *     TaskManager.FirstPage.metataskItem0 = \
     *          com.sgi.product.metatask.FirstMetatask
     * </PRE>
     * indicates that the properties file
     * com.sgi.product.metatask.FirstMetataskP.properties contains the
     * Metatask name and icon.
     */
    static public final String METATASK_ITEM = ".metataskItem";

    /**
     * The string <I>.metatasksText</I> is used to form the intro text
     * for the set of Metatasks to include in a tasklist page.  For
     * example:
     * <PRE>
     *     TaskManager.FirstPage.metatasksText = The following \
     *        tasksets can help you customize your cluster.
     * </PRE>
     */
    static public final String METATASKS_TEXT = ".metatasksText";

    /**
     * The property <I>Metatask.introText</I> is a string containing
     * text to display along with the Metatask name and icon in the
     * DisplayArea of the TaskManager window.  This property is found
     * in the Metatask properties file.
     */
    static public final String METATASK_INTRO_TEXT =
	"Metatask.introText";

    /**
     * The property <I>Metatask.icon</I> is the
     * <A HREF="glossary.html#CLASSPATHRelative">CLASSPATH
     * relative</A> name of an <A
     * HREF="glossary.html#IconImageFile">icon image file</A>
     * of the icon to display along with the Metatask name.  This
     * property is found in the Metatask properties file.
     */
    static public final String METATASK_ICON = "Metatask.icon";

    /**
     * The property <I>Metatask.name</I> is a string to display as the
     * name of the Metatask.  This property is found in the Metatask
     * properties file.
     */
    static public final String METATASK_NAME = "Metatask.name";

    /**
     * The property <I>Metatask.text</I> is a string that contains the
     * text of the Metatask panel.  The text is displayed in a
     * RichTextComponent, so it may contain the limited HTML subset
     * supported by that component.  This property is found in the Metatask
     * properties file.
     */
    static public final String METATASK_TEXT = "Metatask.text";

    /**
     * The property <I>Metatask.keywords</I> is a string that contains
     * a list of whitespace-separated words that can be used to locate
     * the Metatask using the TaskManager search feature.  This
     * property is found in the Metatask properties file.
     */
    static public final String METATASK_KEYWORDS = "Metatask.keywords";

    /**
     * The string <I>.taskGroup</I> is appended to the tasklist
     * page name to form a property set that lists the Task groups
     * that will be displayed in the DisplayArea of the TaskManager
     * window for a particular tasklist page.  For example:
     * <PRE>
     *     TaskManager.TOC.item3 = tasklist
     *     TaskManager.TOC.item3.title = First Page
     *     TaskManager.TOC.item3.target = FirstPage
     *     ...
     *     TaskManager.FirstPage.taskGroup0 = FirstTaskGroup
     * </PRE>
     * This indicates that the TaskManager should look in the
     * TaskRegistry for a group of tasks named "FirstTaskGroup" and to
     * list each of the Tasks specified there.
     */
    static public final String TASK_GROUP = ".taskGroup";

    /**
     * The string <I>.introText</I> is appended to the Task group
     * property to form a property that contains the introductory text
     * for a Task group.  The text is displayed above the list of
     * tasks in the Display Area.
     */
    static public final String TASK_GROUP_INTRO_TEXT = ".introText";

    /**
     * The property <I>TaskManager.DisplayArea.font</I> is a font that
     * is used for text in the Display Area.
     */
    static public final String DISPLAY_AREA_FONT =
				    "TaskManager.DisplayArea.font";

    /**
     * The property <I>TaskManager.DisplayArea.background</I> is a
     * color that is used as the background for the Display Area.
     */
    static public final String DISPLAY_AREA_BACKGROUND =
				    "TaskManager.DisplayArea.background";

    /**
     * The property <I>TaskManager.DisplayArea.foreground</I> is a
     * color that is used as the foreground for the Display Area.
     */
    static public final String DISPLAY_AREA_FOREGROUND =
	"TaskManager.DisplayArea.foreground";

    /**
     * The property <I>TaskManager.DisplayArea.title.font</I> is a
     * font that is used to display the title of a page in the
     * DisplayArea.  DisplayArea.createTitleComponent() uses this font.
     */
    static public final String DISPLAY_AREA_TITLE_FONT =
				    "TaskManager.DisplayArea.title.font";

    /**
     * The property <I>TaskManager.DisplayArea.title.bottomOffset</I>
     * is the margin in <A HREF="glossary.html#Point">points</A>
     * between the bottom of the Display Area title and the top of the
     * first item in the Display Area.
     */
    static public final String DISPLAY_AREA_TITLE_BOTTOM_OFFSET =
			    "TaskManager.DisplayArea.title.bottomOffset";

    /**
     * The property TaskManager.DisplayArea.title.color</I> is a color
     * that is used for the Display Area page title.
     */
    static public final String DISPLAY_AREA_TITLE_COLOR =
				    "TaskManager.DisplayArea.title.color";

    /**
     * The property <I>TaskManager.DisplayArea.extraVerticalSpace</I> is
     * the vertical distance, in <A HREF="glossary.html#Point">points</A>,
     * between items in the Display Area.
     */
    static public final String DISPLAY_AREA_EXTRA_VERTICAL_SPACE =
	"TaskManager.DisplayArea.extraVerticalSpace";

    /**
     * The property <I>TaskManager.DisplayArea.marginTop</I> is the
     * distance, in <A HREF="glossary.html#Point">points</A>, between
     * the top of the Display Area and its contents.
     */
    static public final String DISPLAY_AREA_MARGIN_TOP =
				    "TaskManager.DisplayArea.marginTop";

    /**
     * The property <I>TaskManager.DisplayArea.marginLeft</I> is the
     * distance, in <A HREF="glossary.html#Point">points</A>, between
     * the left side of the Display Area and its contents.
     */
    static public final String DISPLAY_AREA_MARGIN_LEFT =
				    "TaskManager.DisplayArea.marginLeft";

    /**
     * The property <I>TaskManager.DisplayArea.marginBotton</I> is the
     * distance, in <A HREF="glossary.html#Point">points</A>, between
     * the bottom of the Display Area panel and its contents.
     */
    static public final String DISPLAY_AREA_MARGIN_BOTTOM =
				    "TaskManager.DisplayArea.marginBottom";

    /**
     * The property <I>TaskManager.DisplayArea.marginRight</I> is the
     * distance, in <A HREF="glossary.html#Point">points</A>, between
     * the right side of the Display Area and its contents.
     */
    static public final String DISPLAY_AREA_MARGIN_RIGHT =
				    "TaskManager.DisplayArea.marginRight";

    /**
     * The property
     * <I>TaskManager.DisplayArea.verticalUnitIncrement</I> is the
     * distance, in <A HREF="glossary.html#Point">points</A>, that the
     * DisplayArea will scroll when the User clicks on the up or down
     * arrow of the vertical scroll bar.
     */
    static public final String DISPLAY_AREA_VERTICAL_UNIT_INCREMENT =
	"TaskManager.DisplayArea.verticalUnitIncrement";

    /**
     * The string <I>TaskManager.DisplayAreaMetataskLink</I> is used
     * as the name of each link to a Metatask in a tasklist
     * page. This name is used as a prefix to look up properties
     * for the link, which is a RichTextComponent.
     *
     * @see com.sgi.ui.richText.RichTextComponent
     */
    static public final String DISPLAY_AREA_METATASK_LINK =
			    "TaskManager.DisplayAreaMetataskLink";

    /**
     * The string <I>TaskManager.DisplayAreaTaskLink</I> is used
     * as the name of the RichTextComponent for each link to a Task in
     * a tasklist page.  This name is used as a prefix to look up
     * properties for the Task links.
     *
     * @see com.sgi.sysadm.ui.richText.RichTextComponent
     */
    static public final String DISPLAY_AREA_TASK_LINK =
			    "TaskManager.DisplayAreaTaskLink";

    /**
     * The string <I>TaskManager.DisplayAreaText</I> is used
     * as the name of the RichTextComponent for each text area in a
     * tasklist page. This name is used as a prefix to look up
     * properties for the text areas.
     *
     * @see com.sgi.sysadm.ui.richText.RichTextComponent
     */
    static public final String DISPLAY_AREA_TEXT =
	                    "TaskManager.DisplayAreaText";

    /**
     * The property <I>Metatask.closeButtonLabel</I> is a string that
     * defines the label that appears at the bottom of a
     * RichText-based metatask window.
     */
    static public final String METATASK_CLOSE_BUTTON_LABEL =
	"Metatask.closeButtonLabel";

    /**
     * Text that contains links in the DisplayArea or in Metatasks may
     * use the subset of HTML supported by the RichTextComponent.
     * Links to Tasks, Metatasks, and Glossary entries can be added
     * using the following link format:
     * <PRE>
     * Task: &lt;A HREF=task.com.sgi.product.task.MyTask&gt;
     * Metatask: &lt;A HREF=metatask.com.sgi.product.metatask.Metatask&gt;
     * Glossary: &lt;A HREF=glossary.definition&gt;
     * </PRE>
     */
    static public final String TARGET_PREFIX = "<A HREF=";

    /**
     * A String used to identify the end of a link target in
     * TaskManager text.  Literally the String "&gt;".
     *
     * @see com.sgi.sysadm.manager.taskManager.TaskManagerProperties#TARGET_PREFIX
     */
    static public final String TARGET_INFIX = ">";

    /**
     * A String used to identify the end of a hypertext link in
     * TaskManager text. Literally, the String "&lt;A&gt;".
     *
     * @see com.sgi.sysadm.manager.taskManager.TaskManagerProperties#TARGET_PREFIX
     */
    static public final String TARGET_SUFFIX = "</A>";

    /**
     * A String used as part of a Link in TaskManager text
     * that indicates a metatask should be launched when the link is
     * activated.  Literally "<I>metatask.</I>"
     *
     * @see com.sgi.sysadm.manager.taskManager.TaskManagerProperties#TARGET_PREFIX
     */
    static public final String METATASK_TARGET ="metatask.";

    /**
     * A String used as part of a Link in TaskManager text that
     * indicates a task should be launched when the link is
     * activated. Literally "<I>task.</I>"
     *
     * @see com.sgi.sysadm.manager.taskManager.TaskManagerProperties#TARGET_PREFIX
     */
    static public final String TASK_TARGET = "task.";

    /**
     * A String used as part of a Link in TaskManager text
     * that indicates a glossary window should be launched when the
     * link is activated.  Literally "<I>glossary.</I>"
     * @see com.sgi.sysadm.manager.taskManager.TaskManagerProperties#TARGET_PREFIX
     */
    static public final String GLOSSARY_TARGET = "glossary.";

    /**
     * The string <I>TaskManager.</I> is used as the prefix for a
     * number of properties and has been made available to other
     * classes as a convenience.
     */
    static public final String TASKMANAGER_PROPERTY_PREFIX =
	"TaskManager.";

    /**
     * The property <I>TaskManager.Error.missingClass</I> is a format
     * String that is displayed if a table of contents page plugin
     * does not exist.  Argument {0} is the class name, and argument
     * {1} is the page title.  For example, if a table of contents
     * item is of type CLASS but the named class is not found, the
     * missingClass error message will be displayed.
     */
    static public final String MISSING_CLASS_ERROR =
	"TaskManager.Error.missingClass";

    /**
     * The property <I>TaskManager.Error.badPageType</I> is a format
     * String that is displayed if a table of contents page plugin is
     * not of the expected type (specifically TaskManagerPanel).
     * Argument {0} is the class name, and argument {1} is the page
     * title.  For example, if a table of contents item is of type
     * CLASS but the class implements TaskManagerFrame instead of
     * TaskManagerPanel, the badPageType error message will be
     * displayed.
     */
    static public final String BAD_PAGE_TYPE =
	"TaskManager.Error.badPageType";

    /**
     * The boolean property <I>TaskManager.noMenu</I> is set to true if
     * no menubar should be created for the Task Manager window.
     */
    static public final String TASKMANAGER_NOMENU =
	"TaskManager.noMenu";

    /**
     * The string <I>TaskManager.helpMenu</I> is used to define the name
     * of the Help menu.  For example,
     * <PRE>
     *       TaskManager.helpMenu.label = "Help"
     *       TaskManager.helpMenu.mnemonic = "H"
     * </PRE>
     */
    static public final String TASKMANAGER_HELPMENU =
	"TaskManager.helpMenu";

    /**
     * The string <I>TaskManager.helpMenu.item&lt;n&gt;</I>
     * defines the labels to use for the product-specific help menu options.
     * Each option must be accompanied by a mnemonic, the default help text
     * to be displayed, and the name of the help book, and the name of the key
     * which is used to display the correct page in the book.  For example,
     * <PRE>
     *    TaskManager.helpMenu.item0.label = Overview of Task Manager
     *    TaskManager.helpMenu.item0.mnemonic = O
     *    TaskManager.helpMenu.item0.helpBook = Rhino
     *    TaskManager.helpMenu.item0.helpKey = rhino_tmintro
     *    TaskManager.helpMenu.item0.defaultHelpText = \
     *		Follow the blue links.
     * </PRE>
     */
    static public final String TASKMANAGER_HELPMENU_ITEM =
	"TaskManager.helpMenu.item";

    /**
     * The string <I>TaskManager.optionsMenu</I> is used to define the name
     * of the Options menu.  For example,
     * <PRE>
     *       TaskManager.optionsMenu.label = "Options"
     *       TaskManager.optionsMenu.mnemonic = "H"
     * </PRE>
     * The string specified by CLOSE_BUTTON_LABEL will always be the last
     * item in the Options menu.
     *
     * @see com.sgi.sysadm.manager.taskManager.TaskManagerProperties#CLOSE_BUTTON_LABEL
     */
    static public final String TASKMANAGER_OPTIONSMENU =
	"TaskManager.optionsMenu";
}
