//
// TaskManagerTitleRenderer.java
//
//	Interface for clients that want to have control over the
//	TaskManager window title.
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

package com.sgi.sysadm.manager.taskManager;

import com.sgi.sysadm.ui.*;

/**
 * TaskManagerTitleRenderer is a TaskManagerPlugin that allows clients
 * to keep the title of the TaskManager frame up to date.  Once
 * startRendering() has been called, the title renderer has full
 * control over the frame title.  The renderer may monitor TaskData or
 * <A HREF="glossary.html#ProductAttributes">product atttributes</A>
 * or even system state and update the frame title as desired.
 */
public interface TaskManagerTitleRenderer extends TaskManagerPlugin {
    /**
     * Tell the title renderer to set the TaskManager window title and
     * to keep the title current.
     */
    public void startRendering(RFrame frame);
}
