//
// LogViewer.java
//
//	Syslog Viewer
//
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

package com.sgi.sysadm.plugin;

import java.awt.event.*;
import java.awt.*;
import java.io.*;
import java.text.*;
import java.util.*;
import com.sgi.sysadm.util.*;
import javax.swing.*;
import com.sgi.sysadm.category.*;
import com.sgi.sysadm.ui.*;
import com.sgi.sysadm.ui.taskData.*;
import com.sgi.sysadm.manager.*;
import com.sgi.sysadm.manager.taskManager.*;


/**
 **  LogViewer is the entry point for the Syslog Viewer.
 **/
public class LogViewer implements com.sgi.sysadm.manager.taskManager.TaskManagerFrame {
    private LogViewerFrame _frame = null;
    private HostContext _hc;
    private ResourceStack _rs;
    private UIContext _uic;
    private PrivBroker _privBroker;
    private Process _proc = null;
    private String _filterCommand;
    private String[] _filterCommandArgs;
    private String _product;
    private String _class = "LogViewer";
    private boolean _filterSet = false;
    private String _dialogTitle;

    private String _initLines;	// initial number of lines to read from end of SYSLOG
    private static final String READLOG_CMD = "readLog";

    /**
     ** Construct a LogViewer for the given product.
     **
     ** The product-specific LogView properties file will be used if it exists.
     **/
    public LogViewer(String product) {
	_product = product;
	_uic = new UIContext();
	_rs = _uic.getResourceStack();
	_rs.pushBundle(TaskContext.class.getName()
		       + ResourceStack.BUNDLE_SUFFIX);
	_rs.pushBundle(getClass().getName() + ResourceStack.BUNDLE_SUFFIX);
	try {
	    _rs.pushBundle(_product + ".LogViewer" + ResourceStack.BUNDLE_SUFFIX);
	} catch (MissingResourceException ex) {
	    // Product-specific LogViewer.properties file is optional
	}
	_initLines = _rs.getString("LogViewer.initialLines");
	if (_filterSet) {
	    return;
	}
	_filterCommand = _rs.getString("LogViewer.filterCommand");
	_filterCommandArgs = _rs.getStringArray("LogViewer.filterCommandArgs");
	_dialogTitle = _rs.getString("LogViewer.dialogTitle");
	_uic.setDialogTitle(_dialogTitle);
    }

//
// Causes taskmanager error "plugin does not have expected constructor".
// No time right now to make it search harder to find the right one.
//    /**
//     ** Construct a LogViewer using the given filtering command.
//     **
//     ** The supplied filter command and arguments will be used instead of any
//     ** that exist in properties files.
//     ** The product-specific LogView properties file will be used if it exists
//     ** for all other relevant properties.
//     **/
//    public LogViewer(String product, String filterCommand, String[] filterCommandArgs) {
//	_product = product;
//	_filterCommand = filterCommand;
//	_filterCommandArgs = filterCommandArgs;
//	_filterSet = true;
//    }

    //
    // TaskManagerFrame methods
    //

    /**
     ** @see com.sgi.sysadm.manager.taskManager.TaskManagerFrame
     **/
    public void initTaskManagerPlugin(HostContext hc, UIContext uic) {
 	_hc = hc;
	_uic.setHostContext(_hc);
	_privBroker = _hc.getPrivBroker();
    }

    /**
     ** @see com.sgi.sysadm.manager.taskManager.TaskManagerFrame
     **/
    public void taskManagerLaunchFrame() {
	// Check HostContext to see if LogViewer is already
	// running.  If so, raise it to the top and don't bother
	// launching ourselves.
	final String key = getClass().getName();
	Vector clients = _hc.getClients(key);
	if (clients.size() > 0) {
	    ((HostContext.Client)clients.elementAt(0)).getFrame().toFront();
	    return;
	}

	String[] privList = new String[] { READLOG_CMD };
	_uic.getPrivs(privList, new ResultListener() {
	    public void succeeded(ResultEvent event) {
		Log.debug(_class, "checkPrivs succeeded");
		_frame = new LogViewerFrame(_hc, _rs);
		_uic.setDialogParent(_frame.getDialogParent());
		final HostContext.Client client =
		    new HostContext.Client(_frame, _uic);
		_hc.registerClient(client, key);
		_frame.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent we) {
			    _hc.unregisterClient(client);
			    _frame.removeWindowListener(WindowListener.this);
			    _frame = null;
			    if (_proc != null)
				_proc.destroy();
			}
		});
		startReader();
	    }

	    public void failed(ResultEvent event) {
		Log.debug(_class, "checkPrivs failed");
		String reason = event.getReason(); 
		// reason will be null if the user pressed the Cancel
		// button on the privilege dialog.
		if (reason != null) {
		    _uic.postError(reason);
		}
	    }
	});
    }

    private void startReader() {
	String args[] = new String[2 + _filterCommandArgs.length];
	args[0] = _initLines;
	args[1] = _filterCommand;
	for (int ii = 0; ii < _filterCommandArgs.length; ii++) {
	    args[ii+2] = _filterCommandArgs[ii];
	}

	_proc = _privBroker.runPriv(READLOG_CMD, args);
        // Don't close output stream for now.  readLog uses the
	// closure of its stdin as its cue to exit.
// 	try {
// 	    _proc.getOutputStream().close();
// 	} catch (IOException ex) {
// 	    Log.debug(_class, "runPriv IOException");
// 	}
	ProcessWatcher watcher = new ProcessWatcher(_proc);
	watcher.addProcessListener(new ReaderProcessListener());
	watcher.startWatching();
    }

    private class ReaderProcessListener implements ProcessListener {
	// command output to stdout.
	public void processOutputData(ProcessEvent event) {
	    if (_frame != null) {
		_frame.addEntry(new String(event.getBytes()));
	    }
	}

	// command output to stderr.
	public void processErrorData(ProcessEvent event) {
	    // Our UIContext is hosed now because our frame is gone.
	    // So we create a fresh one to display this message.
	    UIContext uic = new UIContext();
	    uic.setDialogTitle(_dialogTitle);
	    uic.postInfo(new String(event.getBytes()));
	}

	public void processExited(ProcessEvent event) {
	    Log.trace(_class, "_processExited");
	    if (_frame != null) {
		_frame.dispatchEvent(
		    new WindowEvent(_frame, WindowEvent.WINDOW_CLOSING));
	    }
/***
	    _uic.postError(_rs.getString("Error.readerExit"),
			new ActionListener() {
				public void actionPerformed(ActionEvent ev) {
					// startReader();
					// Don't restart automatically in
					// case there's a systemic failure.
					// (Process shouldn't die anyway...)
                                }
                            });
***/
	}
    }
}
