//
// LogViewerFrame.java
//
//	Frame for LogViewer.
//
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

package com.sgi.sysadm.plugin;

import com.sgi.sysadm.category.*;
import com.sgi.sysadm.util.*;
import com.sgi.sysadm.ui.*;
import com.sgi.sysadm.ui.taskData.*;
import com.sgi.sysadm.ui.richText.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.text.*;
import java.util.*;
import javax.swing.*;
import javax.swing.text.*;

/**
 * LogViewerFrame displays a LogViewerPanel in a JFrame along with a
 * menu bar.  Commands from the menu act on the LogViewerPanel.
 */
public class LogViewerFrame extends RFrame {
    private HostContext _hc;
    private ResourceStack _rs;
    private RFrame _aboutFrame;
    private JTextArea _textport;
    private JScrollPane _logPane;
    private Font _baseFont;
    private int _maxLines = 1000;	// max size of _textport
    private int _linesLost = 0;		// number scrolled off top

    private String _class = "ViewLogsForm";

    /**
     * 
     * @param hc HostContext for getting PrivBroker.
     * @param rs ResourceStack for getting display parameters.
     */
    public LogViewerFrame(HostContext hc, ResourceStack rs) {
	_hc = hc;
	_rs = rs;

	setTitle(MessageFormat.format(
	    _rs.getString("LogViewer.windowTitle"),
	    new String[] { _hc.getHostName() }));

	setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);

	_baseFont = Font.decode(_rs.getString("LogViewer.baseFont"));
	int width = _rs.getInt("LogViewer.initialWidth");
	int height = _rs.getInt("LogViewer.initialHeight");

	_textport = new JTextArea();
	_textport.setEditable(false);
	_textport.setFont(_baseFont);
	_logPane = new JScrollPane(_textport);
	_logPane.setPreferredSize(new Dimension (width, height));

	setContentPane(_logPane);
	// getContentPane().add(_logPane);
	pack();
	// Work around for Java bug.  New frames without an explicitly set size
	// appear at (0,0) or even (-10,-30).  Getting the initial location
	// (which is random but reasonable) and setting the location to that
	// doesn't work either -- it seems that calling getLocation() before
	// first setting the location causes the set location to get replaced
	// with (0, 0) anyway!
	setLocation(100, 100);		// XXX temporary workaround
	setVisible(true);

	JMenuBar menuBar = new JMenuBar();
	setJMenuBar(menuBar);

	buildOptionsMenu(menuBar);
	pack();
    }

    JComponent getDialogParent() {
	return _logPane;
    }

    public void addEntry(String text) {
	    if (_textport.getLineCount() > _maxLines) {
	    	int linesExtra = _textport.getLineCount() - _maxLines;
		_linesLost += linesExtra;
	    	try {
		    int clearToOffset = _textport.getLineEndOffset(linesExtra);
		    _textport.replaceRange(null, 0, clearToOffset);
	    	} catch (BadLocationException ex) {
		    Log.error(_class, "bad text handling in handleMessage");
	    	}
	    }
	    _textport.append(text);
    }

    /**
     * Add the "Options" menu to menuBar.
     * 
     * @param menuBar menu bar to which we will add the "Options" menu.
     */

    private void buildOptionsMenu(JMenuBar menuBar) {

	JMenu optionsMenu = new JMenu(
	    _rs.getString("LogViewer.optionsMenu.label"));
	// setMnemonic(optionsMenu, "LogViewer.optionsMenu.mnemonic");
	menuBar.add(optionsMenu);

	JMenuItem aboutThis = new JMenuItem(
	    _rs.getString("LogViewer.optionsMenu.aboutThis.label"));
	// setMnemonic(aboutThis, "LogViewer.optionsMenu.aboutThis.mnemonic");
	optionsMenu.add(aboutThis);
	aboutThis.addActionListener(new ActionListener() {
	    public void actionPerformed(ActionEvent event) {
		String aboutString = _rs.getString("LogViewer.aboutThis.Text");
		String aboutTitle = _rs.getString("LogViewer.aboutThis.Title");
		RichTextComponent aboutText = new RichTextComponent(aboutString);
		_aboutFrame = new RFrame(aboutTitle);
		_aboutFrame.getContentPane().add(aboutText);
		_aboutFrame.pack();
		_aboutFrame.setVisible(true);
	    }
	});

	JMenuItem clearDisplay = new JMenuItem(
	    _rs.getString("LogViewer.optionsMenu.clearDisplay.label"));
	// setMnemonic(clearDisplay, "LogViewer.optionsMenu.clearDisplay.mnemonic");
	optionsMenu.add(clearDisplay);
	clearDisplay.addActionListener(new ActionListener() {
	    public void actionPerformed(ActionEvent event) {
		_linesLost += _textport.getLineCount();
		// _textport.replaceRange(null, 0, lastChar);
		_textport.setText(null);
	    }
	});

	optionsMenu.addSeparator();

	JMenuItem close = new JMenuItem(
	    _rs.getString("LogViewer.optionsMenu.close.label"));
	// setMnemonic(close, "LogViewer.optionsMenu.close.mnemonic");
	optionsMenu.add(close);
	close.addActionListener(new ActionListener() {
	    public void actionPerformed(ActionEvent event) {
		// This has to be postponed by doing an invokeLater to
		// avoid an error message being printed about a mouse
		// event coming from a non-showing component.  It
		// seems that the mouse event that activates this menu
		// item also gets sent to whatever is underneath the
		// menu after the menu is gone.
		SwingUtilities.invokeLater(new Runnable() {
		    public void run() {
			dispatchEvent(
			    new WindowEvent(RFrame.this,
					    WindowEvent.WINDOW_CLOSING));
		    }
		});
	    }
	});
    }

    /**
     * Set the mnemonic for a menu item.  A mnemonic is an int, but we
     * don't want to ask people to specify integers in resource files
     * for mnemonics, so we get the mnemonic as a string and use the
     * int value of the first character.
     * 
     * @param menuItem The menu item to set mnemonic for.
     * @param mnemonicResource resource string for mnemonic.
     */
/*** Mnemonics don't work currently.
    private void setMnemonic(JMenuItem menuItem, String mnemonicResource) {
	String mnemonic = _rs.getString(mnemonicResource);
	if (mnemonic.length() > 0) {
	    menuItem.setMnemonic(mnemonic.charAt(0));
	}
    }	
***/
}
