//
// AssociationRef.java
//
//	Reference to a Association.  Simulation of WeakReferences for
//	Java 1.1.
//
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

package com.sgi.sysadm.proxy.category;

import java.util.*;
import com.sgi.sysadm.category.*;
import com.sgi.sysadm.util.*;
import com.sgi.sysadm.proxy.util.*;

/**
 * AssociationRef implements automatic reference counting for
 * AssociationProxy objects.  Each client of AssociationProxy accesses a
 * shared AssociationProxy object via a private AssociationRef object.  When
 * the AssociationRef object gets garbage-collected, it decrements the
 * reference count of its corresponding AssociationProxy object.  When
 * AssociationProxy's reference count goes to 0, it is discarded.
 * This frees Association clients from having to worry about calling
 * get() and release().
 */
class AssociationRef extends Association {
    AssociationProxy _cat;

    /**
     * Construct a AssociationRef.  All public methods are implemented by
     * our referent <tt>cat</tt>.
     * 
     * @param cat Referent Association.
     */
    public AssociationRef(AssociationProxy cat) {
	super(cat.getParentCategoryName(), cat.getParentSelector(),
	      cat.getChildCategoryName());
	_cat = cat;
    }

    //
    // Association public methods are implemented by our referent.
    //
    public void addCategoryListener(CategoryListener listener,
				    NotificationFilter filter) {
	_cat.addCategoryListener(listener, filter);
    }
    public void removeCategoryListener(CategoryListener listener) {
	_cat.removeCategoryListener(listener);
    }
    public void getItem(String selector, ResultListener listener) {
	_cat.getItem(selector, listener);
    }
    public void getItemCount(ResultListener listener) {
	_cat.getItemCount(listener);
    }
    public void getItemList(ResultListener listener) {
	_cat.getItemList(listener);
    }
    protected void startMonitor() {
    }

    /**
     * Called when a AssociationRef gets garbage-collected.  Decrement
     * our AssociationProxy's reference count as appropriate.
     */
    protected void finalize() throws Throwable {
	Releaser.release(_cat);
	super.finalize();
    }
}
