//
// CategoryRef.java
//
//	Reference to a Category.  Simulation of WeakReferences for
//	Java 1.1.
//
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

package com.sgi.sysadm.proxy.category;

import java.util.*;
import com.sgi.sysadm.category.*;
import com.sgi.sysadm.util.*;
import com.sgi.sysadm.proxy.util.*;

/**
 * CategoryRef implements automatic reference counting for
 * CategoryProxy objects.  Each client of CategoryProxy accesses a
 * shared CategoryProxy object via a private CategoryRef object.  When
 * the CategoryRef object gets garbage-collected, it decrements the
 * reference count of its corresponding CategoryProxy object.  When
 * CategoryProxy's reference count goes to 0, it is discarded.
 * This frees Category clients from having to worry about calling
 * get() and release().
 */
class CategoryRef extends Category {
    CategoryProxy _cat;

    /**
     * Construct a CategoryRef.  All public methods are implemented by
     * our reference <tt>cat</tt>.
     * 
     * @param cat Referent category.
     */
    public CategoryRef(CategoryProxy cat) {
	super(cat.getSelector());
	_cat = cat;
    }

    //
    // Category public methods are implemented by our referent.
    //
    public void addCategoryListener(CategoryListener listener,
				    NotificationFilter filter) {
	_cat.addCategoryListener(listener, filter);
    }
    public void addCategoryListener(CategoryListener listener) {
	_cat.addCategoryListener(listener);
    }
    public void removeCategoryListener(CategoryListener listener) {
	_cat.removeCategoryListener(listener);
    }
    public void getItem(String selector, ResultListener listener) {
	_cat.getItem(selector, listener);
    }
    public void getItemCount(ResultListener listener) {
	_cat.getItemCount(listener);
    }
    public void getItemList(ResultListener listener) {
	_cat.getItemList(listener);
    }
    protected void startMonitor() {
    }

    //
    // AttrBundle public method are implemented by our referent
    //
                
    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("Can't clone a Category");
    }
    public void addAttrListener(AttrListener listener) {
	_cat.addAttrListener(listener);
    }
    public void removeAttrListener(AttrListener listener) {
	_cat.removeAttrListener(listener);
    }
    public String getType() {
	return _cat.getType();
    }
    public String getSelector() {
	return _cat.getSelector();
    }
    public String serialize() {
        return _cat.serialize();
    }
    public String toString(int pad) {
        return _cat.toString(pad);
    }
    public String toString() {
	return _cat.toString();
    }
    public void setAttrVisible(String key, boolean visible) {
        Log.fatal("Can't call setAttrVisible on a Category");
    }
    public boolean getAttrVisible(String key) {
	Log.fatal("Can't call getAttrVisible on a Category");
        return false;
    }
    public Attribute getAttr(String key) {
        return _cat.getAttr(key);
    }
    public Attribute removeAttr(String key) {
	Log.fatal("Can't call removeAttr on a Category");
	return null;
    }
    public void removeAllAttrs() {
	Log.fatal("Can't call removeAllAttrs on a Category");
    }
    public void setAttr(Attribute attr) {
	Log.fatal("Can't call setAttr on a Category");
    }
    public void setString(String key, String value) {
	Log.fatal("Can't call setString on a Category");
    }
    public void setLong(String key, long value) {
	Log.fatal("Can't call setLong on a Category");
    }
    public void setDouble(String key, double value) {
	Log.fatal("Can't call setDouble on a Category");
    }
    public void setBoolean(String key, boolean value) {
	Log.fatal("Can't call setBoolean on a Category");
    }
    public void setBundle(String key, AttrBundle value) {
	Log.fatal("Can't call setBundle on a Category");
    }
    public String getString(String key) {
        return _cat.getString(key);
    }
    public String getValueString(String key) {
        return _cat.getValueString(key);
    }
    
    public long getLong(String key) {
        return _cat.getLong(key);
    }
    
    public double getDouble(String key) {
        return _cat.getDouble(key);
    }
    
    public boolean getBoolean(String key) {
        return _cat.getBoolean(key);
    }
    
    public int size() {
        return _cat.size();
    }
    
    public Enumeration getAttrEnum() {
        return _cat.getAttrEnum();
    }
    
    public boolean equals(CategoryRef other) {
        return _cat.equals(other._cat);
    }
        
    /**
     * Called when a CategoryRef gets garbage-collected.  Decrement
     * our CategoryProxy's reference count as appropriate.
     */
    protected void finalize() throws Throwable {
	Releaser.release(_cat);
	super.finalize();
    }
}
