//
// Releaser.java
//
//	Release objects that implement the Releasable interface.
//
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

package com.sgi.sysadm.proxy.util;

import javax.swing.SwingUtilities;

/**
 * Releaser calls release methods on objects that implement the
 * Releaseable interface.  The calls to release methods occur in a
 * separate thread.  Releaser.release is therefore safe to
 * call from a finalize() method, even if the release method itself is
 * not safe to call from a finalize() method.
 * <p>
 * The purpose of this class is to avoid deadlock when using
 * finalize() methods on reference objects to free reference counted
 * objects when they are no longer needed.  This should all go away
 * once we can use weak references.
 */
public class Releaser {
    /**
     * Arrange for <tt>rel</tt> to have its <tt>release</tt> method
     * called from the Releaser thread.  It's OK to call this method
     * from the Releaser thread itself.
     * 
     * @param rel Releaseable whose <tt>release</tt> method is to be
     *            called.
     */
    public static void release(final Releaseable rel) {
	SwingUtilities.invokeLater(new Runnable() {
	    public void run() {
		rel.release();
	    }
	});
    }
}
