//
// BlankIcon.java
//
//	An icon that is blank
//
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

package com.sgi.sysadm.ui;
import java.awt.Graphics;
import java.awt.Component;
import javax.swing.Icon;

/**
 * A class that implements an Icon that shows no image.
 */
public class BlankIcon implements Icon {
    
    private int _width;
    private int _height;
    
    /**
     * Constructor.
     *
     * @param width The width of the Icon
     * @param height The height of the Icon
     */
    public BlankIcon(int width, int height) {
	_width = width;
	_height = height;
    }
    
    /**
     * Returns the height of the icon, as passed to the constructor.
     *
     * @return The height
     */
    public int getIconHeight() {
	return _height; 
    }

    /**
     * Returns the width of the icon, as passed to the constructor.
     *
     * @return The width
     */
    public int getIconWidth() {
	return _width;
    }

    /**
     * Paints the Icon
     *
     * @param comp The Component to be painted
     * @param gr The Graphics object to use to paint
     * @param x The X-coordinate at the upper left of the icon
     * @param y The Y-coordinate at the upper left of the icon
     */
    public void paintIcon(Component comp, Graphics gr, int x, int y) {
    }
}

