//
// BlinkThread.java
//
//	A Globally available thread for blinking icons.
//
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//


package com.sgi.sysadm.ui;
import java.util.*;
import com.sgi.sysadm.util.*;
import javax.swing.*;

public class BlinkThread  {

    private static Vector _blinkers = new Vector();
    private static Thread _blinkThread = null;
    private static int _iconBlinkOnTime = 750;
    private static int _iconBlinkOffTime = 750;
    private static Runnable _onRunnable = new BlinkRunnable(true);
    private static Runnable _offRunnable = new BlinkRunnable(false);

    public static synchronized void addBlinker(final Blinker blinker) {
	_blinkers.addElement(blinker);
	if (_blinkThread == null) {
	    _blinkThread = new Thread("Blink thread") {
		public void run() {
		    try {
			while (true) {
			    sleep(_iconBlinkOnTime);
			    blinkOn();
			    sleep(_iconBlinkOffTime);
			    blinkOff();
			}
		    } catch (InterruptedException ex) {
			Log.fatal(ex.getMessage() + "\n" +
				  SysUtil.stackTraceToString(ex));
		    }
		}
	    };
	    _blinkThread.start();
	} else {
	    _blinkThread.resume();
	}
	
    }
    
    /**
     * Remove a Blinker from our list of Blinkers.
     *
     * @param blinker Blinker to remove.
     */
    public static synchronized void removeBlinker(Blinker blinker) {
	_blinkers.removeElement(blinker);
	if (_blinkThread != null && _blinkers.size() == 0) {
	    _blinkThread.suspend();
	}
    }

    /**
     * Remove all Blinkers from our list of Blinkers, and stop the
     * blink thread.
     */
    public static synchronized void removeAllBlinkers() {
	_blinkers.removeAllElements();
	if (_blinkThread != null) {
	    _blinkThread.suspend();
	}
    }

    /**
     * Notify Blinkers that it's time to turn on.
     */
    private static void blinkOn() {
	SwingUtilities.invokeLater(_onRunnable);
    }
    
    /**
     * Notify blinkers that it's time to turn off.
     */
    private static void blinkOff() {
 	SwingUtilities.invokeLater(_offRunnable);
    }

    private static class BlinkRunnable implements Runnable {
	
	boolean _blinkOn;

	public BlinkRunnable(boolean blinkOn) {
	    _blinkOn = blinkOn;
	}
	
	public void run() {
	    try {
		Enumeration enum = _blinkers.elements();
		while (enum.hasMoreElements()) {
		    if (_blinkOn) {
			((Blinker)enum.nextElement()).blinkOn();
		    } else {
			((Blinker)enum.nextElement()).blinkOff();
		    }
		}
	    } catch (Exception ex) {
		// SwingUtilities.invokeLater does not
		// print exceptions.
		Log.fatal(ex.getMessage() + "\n" +
			  SysUtil.stackTraceToString(ex));
	    }
	}
    }
}









