//
// DynamicSizeLayoutManager.java
//
//      A interface for LayoutManagers who's preferred height depends on
//      their width
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//
package com.sgi.sysadm.ui;

import java.awt.*;

/**
 * DynamicSizeLayoutManager is used in conjunction with RPanel (or
 * other Containers which implement the DynamicSize interface) to
 * allow a Container's height to be determined by its width.
 * @see DynamicSize
 * @see RPanel
 */
public interface DynamicSizeLayoutManager  {
     /**
     * Calculate preferred height given a particular width.  Can
     * be used by LayoutManagers that have special knowledge of the
     * fact that the component's height depends on its width.
     * 
     * @param parent Parent Container to layout.
     * @param width A proposed width for this component.
     * 
     * @return the height this component would like to be given a
     *         width of <tt>width</tt>.
     */
    public int getPreferredHeight(Container parent, int width);
}
