//
// IconRenderer
//
//	A class that can turn an item into an Icon.
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//
package com.sgi.sysadm.ui;

import com.sgi.sysadm.util.*;
import com.sgi.sysadm.category.*;
import com.sgi.sysadm.util.*;
import javax.swing.*;
import java.util.*; 


/**
 *A class that can turn an item into an Icon.
 */
public abstract class IconRenderer extends GenericItemRenderer {

    /**
     * Construct an IconRenderer for a particular Category.
     *
     * @param fullCategoryName The name of the Category that this
     *                         object should render items of.
     * @param rs A ResourceStack that is used to look up properties.
     * @param hc The HostContext that is used to obtain Categories.
     * @see GenericItemRenderer#GenericItemRenderer(String, ResourceStack, HostContext)
     */
    public IconRenderer(String fullCategoryName,
			ResourceStack rs,
			HostContext hc) {
	super(fullCategoryName, rs,hc);
     }
    
    /**
     * Adds a RenderedObjectListener to the renderer
     *
     * @param itemSelector The item the listener is interested in
     * @param context An object that can control the renderer
     * @param iconWidth The width of the icon the listener wants
     * @param iconHeight The height of the icon the listener wants
     * @param listener The listener
     */
    public void addIconListener(String itemSelector, Object context,
				   int iconWidth, int iconHeight,
				   RenderedObjectListener listener) {
	addRenderedObjectListener(itemSelector, listener, 
				  new IconRendererContext (
				      iconWidth, iconHeight, context));
    }
    
    /**
     * Removes an RenderedObjectListener
     *
     * @param itemSelector The Item that the listener is no longer
     *                     interested in. The RenderedObjectListener
     *                     will continue to receive notification about
     *                     other Items that it has registered
     *                     interest in.
     * @param listener The listener.
     */
    public void removeIconListener(String itemSelector,
				   RenderedObjectListener listener) {
	removeRenderedObjectListener(itemSelector, listener);
    }
    
    /**
     * A method to genererate an Icon
     * @param item The Item to base the icon on.
     * @param context The context to use to render the icon
     * @see GenericItemRenderer#createRenderedObject(Item, Object)
     */
    protected Object createRenderedObject(Item item, Object context) {
	IconRendererContext c = (IconRendererContext)context;
	return createIcon(item, c.width, c.height, c.context);
    }

    /**
     * Create the Icon from an Item
     *
     * @param item The Item
     * @param width The desired width of the icon.
     * @param height The desired height of the icon.
     * @param context The context to use to render the icon.
     * @return The Icon
     */
    protected abstract Icon createIcon(Item item, 
				       int width,
				       int height, 
				       Object context);

    private class IconRendererContext {
	public int width;
	public int height;
	public Object context;
	public IconRendererContext(int width, int height, Object context) {
	    this.width = width;
	    this.height = height;
	    this.context = context;
	}
    }
}
