//
// IntegerTextField.java
//
//	A RTextField that only accepts integer input.
//
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

package com.sgi.sysadm.ui;

import javax.swing.*;
import javax.swing.text.*;
import java.awt.*;

/**
 * IntegerTextField is an RTextField that only accepts digits.  If the
 * user types any other character, IntegerTextField beeps.
 */
public class IntegerTextField extends RTextField {

    /*
     * IntegerDocument enforces the limitation that only integers are
     * allowed.
     */
    private static class IntegerDocument extends PlainDocument {
	public void insertString(int offs, String str, AttributeSet a)
	    throws BadLocationException {
	    char ch;
	    for (int i = 0; i < str.length(); i++) {
		if (!Character.isDigit(str.charAt(i))) {
		    Toolkit.getDefaultToolkit().beep();
		    return;
		}
	    }
	    super.insertString(offs, str, a);
	}
    }

    /**
     * Construct an IntegerTextField.
     * 
     * @param columns Number of columns of text.
     */
    public IntegerTextField(int columns) {
	super(new IntegerDocument(), null, columns);
    }
}
