//
// ItemTableColumn.java
//
//	A data structure that describes a column to be used in an ItemTable.
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

package com.sgi.sysadm.ui;

import javax.swing.table.*;

/** 
 * A class that describes a column to be used in an ItemTable.
 */
public class ItemTableColumn {

    /**
     * The string to use as the header for the column
     */
    public String name;

    /**
     * The initial width of the column
     */
    public int width;

    /**
     * The renderer to use for the column
     */
    public TableCellRenderer renderer;

    /**
     * The editor to use for the column
     */
    public TableCellEditor editor;

    /**
     * Construct an ItemTableColumn
     * 
     * @param name The string to use as the header for the column
     * @param width The initial width of the column
     * @param renderer The renderer to use for the column
     * @param editor The editor to use for the column
     */
    public ItemTableColumn(String name, 
			   int width, 
			   TableCellRenderer renderer,
			   TableCellEditor editor){
	this.name = name;
	this.width = width;
	this.renderer = renderer;
	this.editor = editor;
    }
	 
    /**
     * Construct an ItemTableColumn.  Sets the editor to null
     * 
     * @param name The string to use as the header for the column
     * @param width The initial width of the column
     * @param renderer The renderer to use for the column
     */
    public ItemTableColumn(String name, 
			   int width,
			   TableCellRenderer renderer) {
	this(name, width, renderer, null);
    }
    
    /**
     * Construct an ItemTableColumn.  Sets the editor and renderer to null
     * 
     * @param name The string to use as the header for the column
     * @param width The initial width of the column
     */
    public ItemTableColumn(String name, int width) {
	this(name, width, null, null);
    }
}
