//
// ItemTableContext
//   
//	An extension to UIContext that maintains a ResourceStack
//	for ItemTables.
//
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//
package com.sgi.sysadm.ui;

import com.sgi.sysadm.util.*;
import java.awt.*;
import java.util.*;

/** 
 * This is a class that extends UIContext and maintains a
 * ResourceStack for an ItemTable.  The order of ResourceBundles on the
 * stack is : 
 * <ol>
 *  <li>SysadmUIP (bottom of stack, provided by UIContext)
 *  <li>ItemTableContextP
 *  <li>PackageP (many)
 *  <li>&lt;Category_Name&gt;P
 * </ol>
 * The first two are added automatically by the constructor, the rest
 * are derived from <tt>categoryName</tt> that is passed to the
 * constructor.  <tt>pushPackageBundles</tt> is called on
 * ResourceStack with the <tt>categoryName</tt> so all available
 * PackageP files will be on the ResourceStack.
 *
 * @see ResourceStack#pushPackageBundles
 */
public class ItemTableContext extends UIContext {
    
    private static boolean initialized = false;
    private static String CLASS_NAME = "ItemTableContext";
    
    /** 
     * The constructor
     * 
     * @param categoryName The name of the category associated with
     *                     this ItemTableContext, which will be used to
     *                     generate the category properties file name.
     * @param hostContext The HostContext associated with this ItemTableContext
     */
    public ItemTableContext(String categoryName,
			   HostContext hostContext) {
	setHostContext(hostContext);
	getResourceStack().pushBundle(ItemTableContext.class.getName() +
		      ResourceStack.BUNDLE_SUFFIX);
	getResourceStack().pushPackageBundles(categoryName);
	try {
	    getResourceStack().pushBundle(
		categoryName + ResourceStack.BUNDLE_SUFFIX);
	} catch (MissingResourceException mre) {
	    Log.warning(CLASS_NAME,"Couldn't find resource file: " +
			categoryName + ResourceStack.BUNDLE_SUFFIX);
	}
    }
}
