//
// ItemTableModel.java
//
//	A class that controls the JTable that is the ItemTable
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

package com.sgi.sysadm.ui;

import com.sgi.sysadm.category.*;
import com.sgi.sysadm.util.*;
import javax.swing.table.*;
import javax.swing.*;
import java.util.*;

/**
 * This class is used by a JTable to show an ItemTable.
 */
public class ItemTableModel extends AbstractTableModel{
    
    private Vector _data;
    
    public void setData(Vector data) {
	_data = data;
    }
  
    
//-------------Abstract Table Model methods ---------------

    /** 
     * Return the current number of rows that are being displayed
     * @return Current number of rows that are being displayed
     */
    public int getRowCount() {
        if (_data == null) {
            return 0;
        } else {
            return _data.size();
        }
    }

    /** 
     * Returns the current number of columns being displayed 
     * Returns 0 so that if we are using a no-resource
     * ItemTable, there are no columns until an Item arrives.  If
     * a resource file exists, or once an Item arrives, the ItemTable
     * computes the number of columns necessary, and this method is
     * not called.
     *
     * @return Current number of columns being displayed 
     */
    public int getColumnCount() {
	return 0;
    }
    
    /** 
     * Returns the Object at particular row and column
     * @param row The row
     * @param column the column
     * @return The Object at particular row and column
     */
    public Object getValueAt(int row, int column) {
	return ((Vector)_data.elementAt(row)).elementAt(column);
    }

    /** 
     * Gives the Table information on how to display a column.
     * Currently not used
     * @param column The column in question
     * @return The class of the objects in the column
     */
    public Class getColumnClass(int column) {
	Log.fatal("Not supposed to get into getColumnClass()");
	return null;
    }
    
    /** 
     * Returns the label to use for a particular column.
     * Returns null so that if we are using a no-resource
     * ItemTable, there are no columns names until an Item arrives.
     * If a resource file exists, or once an Item arrives, the
     * ItemTable computes the column names, and this method is
     * not called.
     * @param column The column in question
     * @return The name of the column; used for displaying the header.
     */
    public String getColumnName(int column) {
	return null;
    }
}

