//
// ItemTableProperties.java
//
//	A Class that contains all the names of Resources used by
//	ItemTables and associated classes.
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

package com.sgi.sysadm.ui;

/** 
 * A class that contains all the names of properties used by ItemTables
 * and associated classes.
 * <P>
 * The default values for the properties contained here are defined in
 * com.sgi.sysadm.ui.ItemTableContextP.properties and may be
 * overridden by the PackageP.properties file(s) of the product or,
 * more typically, in the &lt;product&gt;.category.&lt;category
 * name&gt;P.properties file.  See
 * the ItemTable documentation for more details.
 * <p>
 * Many of the properties begin with the sequence <i>&lt;name&gt;</i>
 * The <tt>name</tt> that is passed to the ItemTableController should
 * be substituted for this String.  If you use ItemTable's
 * <tt>createItemTable</tt> to create an ItemTable, then the package
 * qualified name of the Category will be passed as <tt>name</tt>.  
 * 
 * @see ItemTable
 * @see ItemTableController
 */
public interface ItemTableProperties {
    
    /**
     * A property <I>ItemTable.factory</I> is a String that gives the package
     * qualified name of a subclass of
     * com.sgi.syadm.ui.ItemTableFactory to use to create an ItemTable.
     * If this is not specified, the default ItemTableFactory will be
     * used to create ItemTables.  This property is used by ItemTable.
     * 
     * @see ItemTable
     * @see ItemTableFactory
     */
    public static final String ITEM_TABLE_FACTORY = "ItemTable.factory";
     
    /** 
     * A property <I>ItemTable.Error.cantLoadClass</i> is the
     * error message that will be displayed if a necessary class can't
     * be loaded.  This property is used by ItemTable and
     * ItemTableFactory.
     *
     * @see ItemTable
     * @see ItemTableFactory
     */
    public static final String CANT_LOAD_CLASS =
        "ItemTable.Error.cantLoadClass";

    // ---------------- Properties used by ItemTableController --------------

    /** 
     * A set of properties <i>ItemTable.column&lt;n&gt;</i>
     * name the columns that will be diplayed in the ItemTable, and
     * define the default order.
     * For information on the use of this property, see the
     * ItemTableController documentation
     *
     * @see ItemTableController
     */
    public static final String COLUMNS = 
        ".ItemTable.column";

    /** 
     * A property 
     * <i>&lt;name&gt;.ItemTable.label.&lt;column&gt;</i> 
     * specifies the label to be used by a particular
     * column. The label will be displayed in the table's header
     * row.  This property is used by ItemTableController.
     *
     * @see ItemTableController
     */
    public static final String LABEL = ".ItemTable.label.";
    
    /** 
     * A property 
     * <i>&lt;name&gt;.ItemTable.method.&lt;column&gt;</i>
     * specifies the way to display a column of the ItemTable.
     * Must be one of: <ul>
     * <li><tt>toString</tt>
     * <li> <tt>componentRenderer</tt>
     * <li><tt>stringRenderer</tt>
     * <li><tt>lookup</tt>
     * <li><tt>richText</tt>
     * <li><tt>richTextRenderer</tt>
     * <li><tt>icon</tt>
     * </ul>
     * For information on the use of each of these methods, see the
     * ItemTableController documentation
     * 
     * @see ItemTableController
     */
    public static final String METHOD = ".ItemTable.method.";

    /** 
     * A property 
     * <i>&lt;name&gt;.ItemTable.lookup.&lt;column&gt;.&lt;Attribute's value&gt;</i>
     * gives the string to display as the value of an cell
     * if the column and value are as specified.  This property is
     * used by ItemTableController.
     *
     * @see ItemTableController
     */
    public static final String LOOKUP = ".ItemTable.lookup.";
    
    /**
     * A property 
     * <I>&lt;name&gt;.ItemTable.basedOn.&lt;column&gt;</I> 
     * is a string that tells which Attribute of the Item is
     * associated with the column given by &lt;column&gt;.
     * This is only necessary if the column name is not the
     * same as the Attribute's name (as returned by <tt>getKey</tt>).
     * This property is used by ItemTableController.  
     *
     * @see ItemTableController
     */
    public static final String BASED_ON = ".ItemTable.basedOn.";

    /**
     * A property 
     * <I>&lt;name&gt;.ItemTable.icon.&lt;column&gt;.&lt;Attribute's value&gt;</i> 
     * is the pathname of an icon to display in the column &lt;column
     * name&gt; if the Attribute's value is equal to &lt;Attribute's
     * value&gt;. This property is used by ItemTableController. 
     *
     * @see ItemTableController
     */
    public static final String ICON = ".ItemTable.icon.";

    /**
     * A property
     * <I>&lt;name&gt;.ItemTable.icon.&lt;column&gt;</i> 
     * is the pathname of an icon to display as a
     * default if a specific icon (as defined by ICON) is not found.
     * This property is used by ItemTableController.
     * @see #ICON
     * @see ItemTableController
     */
    public static final String DEFAULT_ICON = ".ItemTable.icon.";

    /**
     * A property 
     * <I>&lt;name&gt;.ItemTable.width.&lt;column&gt;</I> 
     * is the width (in points) of the column.  This property is used
     * by ItemTableController. 
     *
     * @see ItemTableController
     */
    public static final String WIDTH = ".ItemTable.width.";
 
    /** 
     * A property 
     * <I>&lt;name&gt;.ItemTable.width</I> 
     * is the width (in points) of the column to use if a width is not
     * found for a specific column (as defined by WIDTH).  This
     * property is used by ItemTableController. 
     *
     *
     * @see ItemTableController
     * @see #WIDTH
     */
    public static final String DEFAULT_WIDTH = "ItemTable.width";

    /**
     * A property 
     * <I>&lt;name&gt;.ItemTable.category.&lt;column&gt;</i> 
     * is a string specifying the Category to use to launch the
     * ItemView for a particular column.  This property is only needed
     * if the <tt>column</tt>'s METHOD is <tt>richText</tt>. This property is used by
     * ItemTableController. 
     *
     * @see ItemTableController
     * @see #METHOD
     */
    public static final String CATEGORY = ".ItemTable.category.";
    
    /**
     * A property
     * <i>&lt;name&gt;.ItemTable.selector.&lt;column&gt;</i> 
     * is needed
     * only if <tt>column</tt> is using <tt>richText</tt> as its
     * METHOD.  This property specifies the key of the Attribute whose
     * value should be used as the selector of the ItemView to
     * launch,.  If the selector is the same as the current Item's
     * selector, use the literal String <tt>ITEM_SELECTOR</tt>.  This
     * property is used by ItemTableController. 
     *
     * @see ItemTableController
     * @see #METHOD
     */
    public static final String SELECTOR = ".ItemTable.selector.";

    /**
     * A property 
     * <I>&lt;name&gt;.ItemTable.sort.&lt;column&gt;</I> 
     * is a property that specifies the type of sort to
     * use for the column &lt;column&gt;.  
     * This property is used by ItemTableController.
     * The choices are <tt>lexical</tt>, <tt>numeric</tt>,
     * <tt>none</tt>, and <tt>sorter</tt>
     *
     * @see ItemTableController
     */
    public static final String SORT = ".ItemTable.sort.";
    
    /** A property 
     * <I>&lt;name&gt;.ItemTable.alignment.&lt;column&gt;</I> 
     * specifies the alignment to use for a column.
     * The choices are: <tt>left</tt>, <tt>center</tt>, and <tt>right</tt>.
     *
     * Alignment is only available on columns using the <tt>toString</tt>,
     * <tt>lookup</tt>, or <tt>stringRenderer</tt> methods. 
     * This property is used by ItemTableController. 
     *
     * @see ItemTableController
     */
    public static final String ALIGNMENT = ".ItemTable.alignment.";
    
    /** A property 
     * <I>&lt;name&gt;.ItemTable.missing.&lt;column&gt;</I> 
     * gives a string to use if an
     * Attribute is missing from an Item.  This will be used for the
     * <tt>toString</tt>, <tt>richText</tt>, and <tt>lookup</tt>
     * methods.  This property is used by ItemTableController. 
     *
     * @see ItemTableController
     */
    public static final String MISSING = ".ItemTable.missing.";
    
    /** 
     * A property
     * <i>&lt;name&gt;.ItemTable.columnRenderer</i> 
     * gives the fully qualified name of a class to use as the
     * ItemTableColumnRenderer for this ItemTable.  This property
     * is used by ItemTableController. 
     *
     * @see ItemTableController
     */
    public static final String COLUMN_RENDERER = ".ItemTable.columnRenderer";


    // ---------------- Properties used by ItemTablePanel --------------
    
    /**
     * A property 
     * <i>ItemTablePanel.numRows</i> 
     * specifies the desired height (in rows) of the ItemTable.  This
     * property is used by ItemTablePanel.
     *
     * @see ItemTablePanel
     */
    public static final String NUM_ROWS = "ItemTablePanel.numRows";

    /**
     * A property 
     * <i>ItemTablePanel.IntercellSpacing.width</i> 
     * specifies the width (in points) of the gap to put between
     * cells in the table.  This property is used by ItemTablePanel.
     *
     * @see ItemTablePanel
     */
    public static final String INTERCELL_WIDTH = 
        "ItemTablePanel.IntercellSpacing.width";

    /**
     * A property
     * <i>ItemTablePanel.IntercellSpacing.height</i> 
     * specifies the height (in points) of the gap to put between
     * cells in the table. This property is used by ItemTablePanel.
     *
     * @see ItemTablePanel
     */
    public static final String INTERCELL_HEIGHT = 
        "ItemTablePanel.IntercellSpacing.height";

    /** 
     * A property 
     * <I>ItemTablePanel.selectionMode</I> 
     * specifies the selection mode to use for the table.  The options
     * are:
     * <dl>
     * <dt>SINGLE_SELECTION 
     * <dd>Only one list index can be selected at a time. In this mode
     * the setSelectionInterval and addSelectionInterval methods are
     * equivalent, and only the first index argument is used. 
     *
     * <dt>SINGLE_INTERVAL_SELECTION 
     * <dd> One contiguous index interval can be selected at a
     * time. In this mode setSelectionInterval and
     * addSelectionInterval are equivalent. 
     *
     * <dt>MULTIPLE_INTERVAL_SELECTION 
     * <dd> In this mode, there's no restriction on what can be
     * selected. 
     * </dl>
     * This property is used by ItemTablePanel.
     * @see javax.swing.ListSelectionModel
     *
     * @see ItemTablePanel
     */
    public static final String SELECTION_MODE =
        "ItemTablePanel.selectionMode";
    
    /**
     * A property 
     * <i>ItemTablePanel.rowHeight</i> 
     * is the height (in  points) of each row in the table.  This
     * property is used by ItemTablePanel.
     *
     * @see ItemTablePanel
     */
    public static final String ROW_HEIGHT = "ItemTable.rowHeight";
    
    // ------------------- ItemTableFrame Properties -------------

    /**
     * A property 
     * <i>ItemTableFrame.vgap</i> 
     * that specifies the vertical gap (in points) between the
     * ItemTablePanel and the buttons.  This property is used by
     * ItemTableFrame.
     *
     * @see ItemTableFrame
     */
    public static final String VGAP = "ItemTableFrame.vgap";

    /**
     * A property 
     * <I>ItemTableFrame.okLabel</I> 
     * is a string that specifies the text to be used in the OK
     * button.  This property is used by ItemTableFrame.
     *
     * @see ItemTableFrame
     */
    public static final String OK = "ItemTableFrame.okLabel";

}
