//
// ItemViewInfo
//
//	A class that provides access to the Components that make up a
//	label-value field in the ItemViewPanel.
//
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

package com.sgi.sysadm.ui;

import java.awt.*;
import com.sgi.sysadm.util.*;
import javax.swing.*;

/** 
 * An object of this class is returned by ItemViewPanel when a
 * label-value pair is added to the ItemView.  You can use the
 * getLabel and getValue methods to get the associated Components, and
 * can use the setValueText method to modify the string that the
 * value is displaying.
 */
public class ItemViewInfo {
    private Component _label;
    private Component _value;
    
    /** 
     * Constructor
     * @param label The component that is the label.
     * @param value The component that is the value.
     */
    ItemViewInfo(Component label, Component value) {
	_label = label;
	_value = value;
    }
    
    /** 
     * Modifies the string contained by the "value" Component.  This
     * method assumes that the "value" Component is of type JLabel and
     * will throw an assertion if that is not the case.
     * @param newValue The string to display.
     */
    public void setValueText(String newValue) {
	Log.assert(_value instanceof JLabel, 
		   "Tried to use setValueText on a value that "+
		   "wasn't a JLabel");
	((JLabel)_value).setText(newValue);
	_value.invalidate();
    }
    
    /** 
     * Modifies the string contained by the "label" Component.  This
     * method assumes that the "label" Component is of type JLabel and
     * will throw an assertion if that is not the case.
     * @param newValue The string to display.
     */
    public void setLabelText(String newValue) {
	Log.assert(_value instanceof JLabel, 
		   "Tried to use setLabelText on a value that "+
		   "wasn't a JLabel");
	((JLabel)_label).setText(newValue);
	_label.invalidate();
    }
    

    /**
     * Returns the Component that is the label
     * @return the label Component
     */
    public Component getLabel() {
	return _label;
    }
    /**
     * Returns the Component that is the value
     * @return the value Component
     */  
    public Component getValue() {
	return _value;
    }
}

