//
// ItemViewPanel
//
//	A class that displays an ItemView
//
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

package com.sgi.sysadm.ui;

import java.util.Vector;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import com.sgi.sysadm.category.*;
import com.sgi.sysadm.util.*;


/**
 * An ItemViewPanel defines the overall look of the ItemView.  See
 * the ItemView documents for more information
 * 
 * @see ItemView
 */
public class ItemViewPanel extends JPanel implements ItemViewProperties {
  
    private final static String CLASS_NAME = "ItemViewPanel";
    private JPanel _topPanel = new JPanel();
    private JLabel _icon = new JLabel();
    private TwoColumnPanel _infoPanel;
    private JPanel _centerPanel = new JPanel();
    private OneColumnPanel _bottomPanel;
    private JPanel _additionalInfoPanel = new JPanel(new BorderLayout());
    private JSeparator _additionalInfoSeparator = new JSeparator();
    private JPanel _taskShelfPanel =new JPanel(
	new FlowLayout(FlowLayout.LEFT, 0, 0));
    private JSeparator _taskShelfSeparator = new JSeparator();
    private ResourceStack _rs;
    private int _width;
    private int _height;
    
    /** 
     * Constructor for ItemViewPanel
     *
     * @param ivc The ItemViewContext for the panel
     */
    public ItemViewPanel(ItemViewContext ivc) {
	// Overall look is icon and detailed info at the top,
	// malleable info in the middle, and task shelf below that.
	_rs = ivc.getResourceStack();
	_infoPanel = new TwoColumnPanel(_rs);
	int marginHeight = _rs.getPixels(MARGIN_HEIGHT);
	int marginWidth = _rs.getPixels(MARGIN_WIDTH);
	setBorder(BorderFactory.createEmptyBorder(marginHeight,
						  marginWidth,
						  marginHeight,
						  marginWidth));
	int vgap = _rs.getPixels(VGAP);
	int hgap = _rs.getPixels(HGAP);
	_width = _rs.getPixels(PANEL_WIDTH);
	_height = _rs.getPixels(PANEL_HEIGHT);
	setLayout(new BorderLayout(0,vgap));
	
	_topPanel.setLayout(new GridBagLayout());
	GridBagConstraints gbc = new GridBagConstraints();
	gbc.anchor = GridBagConstraints.NORTH;
	gbc.gridx = 0;
	gbc.gridy = 0;
	gbc.insets = new Insets(0,0,0,hgap);
	_topPanel.add(_icon, gbc);
	gbc.anchor = GridBagConstraints.CENTER;
	gbc.fill = GridBagConstraints.BOTH;
	gbc.gridx = 1;
	gbc.weightx = 1;
	gbc.weighty = 1;
	_topPanel.add(_infoPanel,gbc);
	add(_topPanel, BorderLayout.NORTH);

	_centerPanel.setLayout(new BoxLayout(_centerPanel,
					     BoxLayout.Y_AXIS));
	_bottomPanel = new OneColumnPanel(_rs);
	_additionalInfoSeparator.setVisible(false);
	_taskShelfSeparator.setVisible(false);

        int w = _rs.getPixels(ADD_MARGIN_WIDTH);
        int h = _rs.getPixels(ADD_MARGIN_HEIGHT);
        
        _additionalInfoPanel.setBorder(BorderFactory.createEmptyBorder(h,w,h,w));
	_centerPanel.add(_additionalInfoSeparator);
	_centerPanel.add(_additionalInfoPanel);
	_centerPanel.add(_taskShelfSeparator);

	_bottomPanel.addComponent(
	    _taskShelfPanel, 
	    new LinkLabel(_rs, TASK_SHELF_TITLE));

	add(_centerPanel, BorderLayout.CENTER);
	add(_bottomPanel,BorderLayout.SOUTH);
	}

    /**
     * Returns the preferred size for this frame. 
     * @return The Dimension as specified by the WIDTH and HEIGHT
     *         resources.
     */
    public Dimension getPreferredSize() {
	return new Dimension(_width,_height);
    }
    
    /** 
     * Sets the panel's icon to a specified icon
     * @param icon The icon to display
     */
    public void setIcon(Icon icon) {
	_icon.setIcon(icon);
    }
    
    /** 
     * Sets the Component that will be displayed in the "task shelf"
     * area of the panel.
     * @param taskShelf The TaskShelf to display
     */
    public void setTaskShelf(Component taskShelf) {
	_taskShelfPanel.removeAll();
	if (taskShelf == null) {
	    _taskShelfSeparator.setVisible(false);
	} else {
	    _taskShelfPanel.add(taskShelf);
	    _taskShelfSeparator.setVisible(true);
	}
    }
 
    /** 
     * Sets the Component that will be displayed in the "additional info"
     * area of the panel.
     * @param additionalInfo The Component to put in the "additional
     *                       info" area.
     */
    public void setAdditionalInfo(Component additionalInfo) {
	_additionalInfoPanel.removeAll();
	if (additionalInfo == null) {
	    _additionalInfoSeparator.setVisible(false);
	} else {
	    _additionalInfoPanel.add(additionalInfo, BorderLayout.CENTER);
	    _additionalInfoSeparator.setVisible(true);
	}
    }
    
    /** 
     * Adds a label and value to the "info" part of the panel.
     * @param label The label to display.  Will be used in the
     *              constructor of a LinkLabel
     * @param value The value to display
     *
     * @return An ItemViewInfo object that contains the Components
     *         that were added to the panel for use when modifying the
     *         values of the label or the value.
     * @see LinkLabel
     */
    public ItemViewInfo addItemViewInfo(String label, String value) {
	return addItemViewInfo(new LinkLabel(_rs, label), 
			       new RLabel(value, _rs, VALUE_RLABEL_NAME));
    }

    /** 
     * Adds a label and value to the "info" part of the panel.
     * @param label The label to display.  Will be used in the
     *              constructor of a LinkLabel
     * @param value The value to display
     *
     * @return An ItemViewInfo object that contains the Components
     *         that were added to the panel for use when modifying the
     *         values of the label or the value.
     * @see LinkLabel
     */
    public ItemViewInfo addItemViewInfo(String label, Component value) {
	return addItemViewInfo(new LinkLabel(_rs, label), value);
    }
    
    /** 
     * Adds a label and value to the "info" part of the panel.
     * @param label The label to display
     * @param value The value to display
     * @return An ItemViewInfo object that contains the Components
     *         that were added to the panel for use when modifying the
     *         values of the label or the value.
     */
    public ItemViewInfo addItemViewInfo(Component label,
					Component value) {
	_infoPanel.addComponent(value, label);
	return new ItemViewInfo(label, value);
    }
     
    /** 
     * Adds a label and value to the "info" part of the panel.
     * @param label The label to display
     * @param value The value to display
     * @return An ItemViewInfo object that contains the Components
     *         that were added to the panel for use when modifying the
     *         values of the label or the value.
     */
    public ItemViewInfo addItemViewInfo(Component label,
					String value) {
	return addItemViewInfo(label, new RLabel(value, _rs, VALUE_RLABEL_NAME));
    }

    /** 
     * Removes a label and value from the "info" part of the panel
     * @param ivi The ItemViewInfo object that was returned when the
     *            label-value pair was added.
     */
    public void removeItemViewInfo(ItemViewInfo ivi){
	_infoPanel.removeComponent(ivi.getLabel());
	_infoPanel.removeComponent(ivi.getValue());
    }
}
