//
// ItemViewProperties.java
//
//	A Class that contains all the names of Properties used by
//	ItemViews and associated classes.
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

package com.sgi.sysadm.ui;

/**
 * A class that contains all the names of Properties used by ItemViews
 * and associated classes.
 * <P>
 * The default values for the properties contained here are defined in
 * com.sgi.sysadm.ui.ItemViewContextP.properties and may be
 * overridden by the PackageP.properties file(s) of the product or,
 * more typically, in the &lt;product&gt;.category.&lt;category
 * name&gt;P.properties file.  See
 * the ItemView documentation for more details.
 * <p>
 * Many of the properties begin with the sequence <i>&lt;name&gt;</i>
 * The <tt>name</tt> that is passed to the ItemViewController should
 * be substituted for this String.  If you use ItemView's
 * <tt>createItemView</tt> to create an ItemView, then the package
 * qualified name of the Category will be passed as <tt>name</tt>.
 *
 * @see ItemView
 * @see ItemViewController
 * @see ItemView#createItemView
 */
public interface ItemViewProperties {

    /**
     * A property <I>ItemView.Error.cantLoadClass</i> gives the
     * error message that will be displayed if a necessary class can't
     * be loaded.
     */
    public static final String CANT_LOAD_CLASS =
    "ItemView.Error.cantLoadClass";

//  ----------------------- ItemView Properties -----------------
    /**
     * A property <I>ItemView.factory</I> is a String that gives the
     * package qualified name of a subclass of
     * com.sgi.syadm.ui.ItemViewFactory to use to create an ItemView.
     * If this is not specified, the default ItemViewFactory will be
     * used to create ItemViews.  This property is used by ItemView.
     *
     * @see ItemView
     * @see ItemViewFactory
     */
    public static final String ITEM_VIEW_FACTORY = "ItemView.factory";

    /**
     * A property <i>ItemView.iconHeight</I> is the height, in points,
     * of the icon. This property is used by ItemView.
     *
     * @see ItemView
     */
    public static final String ICON_HEIGHT = "ItemView.iconHeight";

    /**
     * A property <i>ItemView.iconWidth</I> is the width, in points,
     * of the icon. This property is used by ItemView.
     *
     * @see ItemView
     */
    public static final String ICON_WIDTH = "ItemView.iconWidth";

 //  ----------------------- ItemViewFactory Properties -----------------

    /**
     * A property
     * <i>&lt;name&gt;ItemView.fieldRenderer</i>
     * gives the fully
     * qualified name of a class to use as the
     * ItemViewFieldRenderer for this ItemView. This property is used by ItemViewFactory.
     *
     * @see ItemViewFactory
     */
    public static final String FIELD_RENDERER =
	".ItemView.fieldRenderer";

    /**
     * A property <i>&lt;name&gt;.ItemView.additionalInfoRenderer</i> gives the
     * fully qualified name of a class to use as the
     * ItemViewAdditionalInfoRenderer for this ItemView. This property
     * is used by ItemViewFactory.
     *
     * @see ItemViewFactory
     */
    public static final String ADDITIONAL_INFO_RENDERER =
    ".ItemView.additionalInfoRenderer";

//  ----------------------- ItemViewPanel Properties -----------------

    /**
     * A property <i>ItemViewPanel.vgap</i> specifies the vertical
     * gap (in points) between taller of the icon or the fields
     * and the AdditionalInfo panel, and between the AdditionalInfo
     * and the TaskShelf. This property is used by ItemViewPanel.
     *
     * @see ItemViewPanel
     */
    public static final String VGAP = "ItemViewPanel.vgap";

    /**
     * A property <i>ItemViewPanel.hgap</i> specifies the
     * horizontal gap (in points) between the icon and the info
     * strings.  This property is used by ItemViewPanel.
     *
     * @see ItemViewPanel
     */
    public static final String HGAP = "ItemViewPanel.hgap";

    /**
     * A property <i>ItemViewPanel.width</i> specifies the width
     * (in points) of the panel.  This property is used by ItemViewPanel.
     *
     * @see ItemViewPanel
     */
    public static final String PANEL_WIDTH = "ItemViewPanel.width";

     /**
     * A property <i>ItemViewPanel.height</i> specifies the height
     * (in points) of the panel.  This property is used by ItemViewPanel.
     *
     * @see ItemViewPanel
     */
    public static final String PANEL_HEIGHT = "ItemViewPanel.height";

    /**
     * A property <i>ItemViewPanel.marginHeight</i> specifies the height
     * (in points) of the margin at the top and bottom of the panel.
     * This property is used by ItemViewPanel.
     *
     * @see ItemViewPanel
     */
    public static final String MARGIN_HEIGHT = "ItemViewPanel.marginHeight";

    /**
     * A property <i>ItemViewPanel.marginWidth</i> specifies the width
     * (in points) of the margin at the left and right of the panel.
     * This property is used by ItemViewPanel.
     *
     * @see ItemViewPanel
     */
    public static final String MARGIN_WIDTH = "ItemViewPanel.marginWidth";

    /**
     * The string <i>ItemView.values</i> is the string that is used
     * as the name of the RLabels that are created for the values in
     * the calls to addItemViewInfo.  ItemViewAdditionalInfoRenderers
     * can use this as the name of RLabels they create so that their
     * RLabels match the infrastructure's RLabels.
     */
    public static final String VALUE_RLABEL_NAME = "ItemView.values";

    /**
     * The string <i>ItemView.taskShelfTitle</i> is the string used
     * as the label for the task shelf.  This property is used by
     * ItemViewPanel.
     *
     * @see ItemViewPanel
     */
    public static final String TASK_SHELF_TITLE = "ItemView.taskShelfTitle";

    /**
     * The property <i>ItemViewPanel.additionalInfo.marginWidth</i>
     * is the width (in points) of the margin around the additional info
     * panel.  This property is used by ItemViewPanel.
     *
     * @see ItemViewPanel
     */
    public static final String ADD_MARGIN_WIDTH =
	"ItemViewPanel.additionalInfo.marginWidth";

    /**
     * The property <i>ItemViewPanel.additionalInfo.marginHeight</i>
     * is the height (in points) of the margin around the additional info
     * panel.  This property is used by ItemViewPanel.
     *
     * @see ItemViewPanel
     */
    public static final String ADD_MARGIN_HEIGHT =
	"ItemViewPanel.additionalInfo.marginHeight";

//  --------------------- ItemViewController Properties ---------------

    /**
     * A set of properties <i>&lt;name&gt;.ItemView.fields&lt;n&gt;</i>
     * specifies the order in which to display the fields in a
     * ItemView.  This property is used by ItemViewController.
     *
     * @see ItemViewController
     */
    public static final String FIELDS =
	".ItemView.field";

    /**
     * A property
     * <i>&lt;name&gt;.ItemView.label.&lt;field&gt;</i> specifies the
     * label to be used by a particular field, where &lt;field&gt; should be
     * the field, as defined by the FIELDS property, and &lt;name&gt;
     * is the name that was passed the the constructor of
     * ItemViewController.  This property is used by
     * ItemViewController.
     *
     * @see ItemViewController
     */
    public static final String LABEL = ".ItemView.label.";

    /**
     * A property <I>&lt;name&gt;.ItemView.basedOn.&lt;field&gt;</I>
     * is a string that tells
     * which Attribute of the Item is associated with the field given by
     * &lt;field&gt;, where &lt;name&gt; is the name that was passed the
     * the constructor of ItemViewController.  This is only necessary
     * if the fields's name is not the same as the Attribute's key
     * (as returned by <tt>getKey</tt>)  This property is used by
     * ItemViewController.
     *
     * @see ItemViewController
     */
    public static final String BASED_ON = ".ItemView.basedOn.";

    /**
     * A property
     * <i>&lt;name&gt;.ItemView.method.&lt;field&gt;</i>
     * specifies the way to generate a field.
     * Must be one of: <ul>
     * <li><tt>toString</tt>
     * <li><tt>richText</tt>
     * <li><tt>renderer</tt>
     * <li><tt>lookup</tt>
     * </ul>
     * This property is used by ItemViewController.
     *
     * @see ItemViewController
     */
    public static final String METHOD = ".ItemView.method.";

    /**
     * A property
     * <i>&lt;name&gt;.ItemView.lookup.&lt;field&gt;.&lt;Attribute's value&gt;</i>
     * gives the string to display as the value of an field
     * if the field and the value of the Attribute that this field is
     * based on are are specified.  This property is used by ItemViewController.
     *
     * @see ItemViewController
     */
    public static final String LOOKUP = ".ItemView.lookup.";

    /**
     * A property <i>&lt;name&gt;.ItemView.itemNotFoundError</i> is
     * the string to display in a dialog box if an ItemView is set to
     * an Item that does not exist.  If the string has a {0} sequence,
     * it will be replaced with the selector of the Item that was not
     * found.  If this property does not exist or is empty, then no
     * dialog will be displayed.  This property is used by ItemViewController.
     *
     * @see ItemViewController
     */
    public static final String ITEM_NOT_FOUND_ERROR =
	".ItemView.itemNotFoundError";

    /**
     * A property <I>&lt;name&gt;.ItemView.itemDeleted</I> is the
     * string to display in a dialog box when the Item is deleted.  If
     * the string has a {0} sequence, it will be replaced with the
     * selector of the deleted Item.  If this property does not exist
     * or is empty, then no dialog will be displayed.  This property
     * is used by ItemViewController.
     *
     * @see ItemViewController
     */
    public static final String ITEM_DELETED =
	".ItemView.itemDeleted";

    /**
     * A property <i>&lt;name&gt;.ItemView.category.&lt;field&gt;</i>
     * is needed only if
     * &lt;field&gt; is using <tt>richText</tt> as its display
     * method.  This property specifies the Category to use when
     * lauching an ItemView.  This property is used by ItemViewController.
     *
     * @see ItemViewController
     */
    public static final String CATEGORY = ".ItemView.category.";

    /**
     * A property <i>&lt;name&gt;.ItemView.selector.&lt;field&gt;</i>
     * is needed only if  &lt;field&gt; is using <tt>richText</tt> as its display
     * method.  This property specifies the key of the Attribute whose
     * value should be used as the selector of the ItemView to
     * launch.  To use the same selector as the Item being displayed
     * in the ItemView, use the literal string <I>ITEM_SELECTOR</I>
     * This property is used by ItemViewController.
     *
     * @see ItemViewController
     */
    public static final String SELECTOR = ".ItemView.selector.";

    /**
     * A property <I>&lt;name&gt;.ItemView.missing.&lt;field&gt;</I>
     * gives a string to use if the Attribute that
     * this field is based on is missing from the Item.  This will be
     * used for the toString, richText, and lookup methods.  This
     * property is used by ItemViewController.
     *
     * @see ItemViewController
     */
    public static final String MISSING = ".ItemView.missing.";

    /**
     * A property <I>&lt;name&gt;.ItemView.empty.&lt;field&gt;</I>
     * gives a string to use if the Attribute that
     * this field is based on is empty (string length 0).  This will be
     * used for the toString, richText, and lookup methods.  This
     * property is used by ItemViewController.
     *
     * @see ItemViewController
     */
    public static final String EMPTY = ".ItemView.empty.";

// -------------------- ItemViewFrame properties ----------------

    /**
     * A property <i>ItemViewFrame.vgap</i> specifies the
     * vertical gap (in points) between the ItemViewPanel and the
     * buttons.  This property is used by ItemViewFrame.
     *
     * @see ItemViewFrame
     */
    public static final String FRAME_VGAP = "ItemViewFrame.vgap";

    /**
     * A property <I>ItemViewFrame.okLabel</I> is a string that
     * specifies the text to be used in the OK button.  This property
     * is used by ItemViewFrame.
     *
     * @see ItemViewFrame
     */
    public static final String FRAME_OK = "ItemViewFrame.okLabel";

}
