//
// NameRenderer
//
//	A class that can turn an item into an name.
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//
package com.sgi.sysadm.ui;

import com.sgi.sysadm.util.*;
import com.sgi.sysadm.category.*;
import com.sgi.sysadm.util.*;
import javax.swing.*;
import java.util.*;

/**
 *A class that can turn an item into an name.
 */
public abstract class NameRenderer extends GenericItemRenderer {
    /**
     * Create a NameRenderer for a specific category.
     *
     * @param fullCategoryName The name of the Category that this
     *                         object should render Items of.
     * @param rs A ResourceStack
     * @param hc The HostContext
     */
    public NameRenderer(String fullCategoryName,
			ResourceStack rs,
			HostContext hc) {
	super(fullCategoryName, rs,hc);
     }
    
    /**
     * Adds a RenderedObjectListener to the renderer
     *
     * @param itemSelector The item the listener is interested in
     * @param context An object that can control the renderer
     * @param listener The listener
     */
    public void addNameListener(String itemSelector, Object context,
				RenderedObjectListener listener) {
	addRenderedObjectListener(itemSelector, listener, context);
    }
    
    /**
     * Removes a RenderedObjectListener
     *
     * @param itemSelector The item that the listener is no longer
     * interested in. The  RenderedObjectListener will continue to receive
     * notification about other items that it has registered interest
     * in.
     * @param listener The listener.
     */
    public void removeNameListener(String itemSelector,
				   RenderedObjectListener listener) {
	removeRenderedObjectListener(itemSelector, listener);
    }
    
    /**
     * A method to generate an name
     *
     * @param item The Item to base the name on.
     * @param context The context Object to pass the the renderer.
     */
    protected Object createRenderedObject(Item item, Object context) {
	return createName(item, context);
    }

    protected abstract String createName(Item item, 
					 Object context);

}
