//
// RButtonGroup.java
//
//      A subclass of RButtonGroup that can be used with
//      LongRButtonGroupBinder
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

package com.sgi.sysadm.ui;

import javax.swing.*;
import javax.swing.event.*;
import java.util.*;

/**
 * A subclass of ButtonGroup that can be used with
 * LongRButtonGroupBinder.
 *
 * @see ButtonGroup
 * @see LongRButtonGroupBinder
 */
public class RButtonGroup extends ButtonGroup {
    
    private Vector _listeners = new Vector();
    private long _currentSelection = -1;
    private Vector _models = new Vector();
    private CListener _cListener = new CListener();
    
    /**
     * Adds a button to the group.
     */
    public void add(AbstractButton b) {
	super.add(b);
	_models.addElement(b.getModel());
	b.addChangeListener(_cListener);
    }
    
    /**
     * Remove a button from the group.
     */
    public void remove(AbstractButton b) {
	super.remove(b);
	_models.removeElement(b.getModel());
	b.removeChangeListener(_cListener);
    }
    
    /**
     * Add a RButtonGroupListener to this RButtonGroup.  The listener
     * will be notified when the selection (which button in the group
     * is selected) changes.
     *
     * @param listener The listener to add
     */
    public void addRButtonGroupListener(RButtonGroupListener listener) {
	_listeners.addElement(listener);
	if (_currentSelection != -1) {
	    listener.selectionChanged(_currentSelection);
	}
    }
    
    /**
     * Remove a RButtonGroupListener from this RButtonGroup. 
     *
     * @param listener The listener to remove
     */
    public void removeRButtonGroupListener(RButtonGroupListener listener) {
	_listeners.removeElement(listener);
    }
    
    /**
     * Notify the listeners that the selection has changed
     */
    private void notifyChanged() {
	for (int ii = 0; ii < _listeners.size(); ii++) {
	    ((RButtonGroupListener)_listeners.elementAt(ii)).
		selectionChanged(_currentSelection);
	}
    }
      
    /**
     * Select a button by its index.  The index starts at zero
     * and is determined by the order that the buttons were added to
     * the group.
     *
     * @param index  The index of the button to select.
     */
    public void setSelectedIndex(long index) {
	setSelected((ButtonModel)_models.elementAt((int)index), true);
    }
    
    /**
     * Returns the index of the selected button.  The index starts at zero
     * and is determined by the order that the buttons were added to
     * the group.
     *
     * @return The index of the selected button
     */
    public long getSelectedIndex() {
	return _currentSelection;
    }
    
    /**
     * An interface for classes that are interested in knowing when
     * the selection changes
     */
    public interface RButtonGroupListener extends EventListener {
	/**
	 * Called when the selected button changes.
	 * The index starts at zero and is determined by the order that
	 * the buttons are added to the group.
	 *
	 * @param selection The index of the selected button. 
	 */
	public void selectionChanged(long selection);
    }

    /**
     * A class that implements a ChangeListener
     */
    private class CListener implements ChangeListener {
	public void stateChanged(ChangeEvent e) {
	    long newSelection = _models.indexOf(getSelection());
	    if (newSelection != _currentSelection) {
		_currentSelection = newSelection;
		notifyChanged();
	    }
	}
    }
}



















