//
// RRadioButton.java
//
//	A subclass of JCheckBox that implements ExtraCleanup to get
//	around java bug 4129207.
//
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

package com.sgi.sysadm.ui;
import javax.swing.*;

/**
 * A subclass of JCheckBox that implements ExtraCleanup to get around
 * java bug 4129207, which causes memory leaks.
 * <p> 
 * All constructors are the same as JCheckBox's.
 */
public class RCheckBox extends JCheckBox implements ExtraCleanup {

    /**
     * @see com.sgi.sysadm.ui.ExtraCleanup
     */
    public void extraCleanup() {
	/// XXX needed to fix java bug 4129207
	listenerList = null;
    }

    /**
     * @see JCheckBox
     */
    public RCheckBox() {
	super();
    }

    /**
     * @see JCheckBox#JCheckBox(Icon)
     */
    public RCheckBox(Icon icon) {
	super(icon);
    }

    /**
     * @see JCheckBox#JCheckBox(Icon, boolean)
     */
    public RCheckBox(Icon icon, boolean selected) {
	super(icon, selected);
    }

    /**
     * @see JCheckBox#JCheckBox(String)
     */
    public RCheckBox(java.lang.String text) {
	super(text);
    }

    /**
     * @see JCheckBox#JCheckBox(String, boolean)
     */
    public RCheckBox(java.lang.String text, boolean selected) {
	super(text, selected);
    }

    /**
     * @see JCheckBox#JCheckBox(String, Icon)
     */
    public RCheckBox(java.lang.String text, Icon icon) {
	 super(text, icon);
     }

    /**
     * @see JCheckBox#JCheckBox(String, Icon, boolean)
     */
    public RCheckBox(java.lang.String text, Icon icon, boolean selected) {
	 super(text, icon, selected);
     }
}
