//
// RDialog.java
//
//	Rhino Dialog, which catches removeNotify() exceptions after
//	de-iconification.
//
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

package com.sgi.sysadm.ui;

import javax.swing.*;
import com.sgi.sysadm.util.*;
import java.awt.*;

/**
 * RDialog is a JDialog that can handle having its owner
 * programmatically de-iconified via calls to removeNotify and
 * addNotify.  RDialog catches exceptions thrown by JDialog when an
 * RFrame owner that has been de-iconified is closed.
 * <p>
 * RDialog also returns its owning Frame when <tt>getOwner</tt> is called.
 * <p>
 * Dialogs are typically displayed using the UIContext class.
 * @see UIContext
 */
public class RDialog extends JDialog {

    private Frame _owner;
    private boolean _packed = false;
    
    /**
     * Construct an RDialog.
     * 
     * @param owner Frame owner of this dialog.
     */
    public RDialog(Frame owner) {
	super(owner);
	_owner = owner;
    }

    /**
     * Called when our peer is to be removed.  Overridden from JDialog
     * to catch exceptions that occur after Frames are de-iconified
     * by calling <tt>removeNotify</tt> and <tt>addNotify</tt>.
     * @see RFrame
     */
    public void removeNotify() {
	try {
	    super.removeNotify();
	} catch (Exception ex) {
	    Log.debug("RDialog", "removeNotify caught an exception");
	}
    }

    /**
     * Get the Frame owner of this RDialog.
     * 
     * @return Frame owner of this RDialog.
     */
    public Frame getOwner() {
	return _owner;
    }

    /**
     * Calls super.pack() twice to work around bug in Java 2 where the
     * "Warning: Applet Window" message messes up dialog layouts.
     */
    public void pack() {
	if (!_packed && getWarningString() != null) {
	    super.pack();
	}
	_packed = true;
	super.pack();
    }
}
