//
// RPasswordField.java
//
//      A subclass of JPasswordField that uses monospaced font.
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

package com.sgi.sysadm.ui;

import com.sgi.sysadm.util.*;
import javax.swing.text.Document;
import javax.swing.*;
import java.awt.*;

/**
 * This class is a JPasswordField that uses a monospace font and sets
 * the substitution character based on resources (described below).
 * Using a monospace font in a text field assures that the number of
 * input characters displayed is equal to the column width of the text
 * field.
 * <P>  
 * The font and margin properties are shared with RTextField and
 * ItemFinder.
 *
 * @see javax.swing.JPasswordField
 * @see com.sgi.sysadm.ui.RTextField
 * @see com.sgi.sysadm.ui.ItemFinder
 */
public class RPasswordField extends JPasswordField {

    /** 
     * A resource <i>Field.font</i> defined in
     * <TT>com.sgi.sysadm.ui.SysadmUIP.properties</TT> that specifies
     * the font to be used in Task TextFields, ItemFinders, password
     * fields, and so on.  It may be overridden in
     * {package}/PackageP.properties, but please note that this
     * resource is shared with RTextField and ItemFinder.
     */
    public static final String FONT = "Field.font";

    /** 
     * A resource <i>PasswordField.echoChar</i> defined in
     * <TT>com.sgi.sysadm.ui.SysadmUIP.properties</TT> that specifies
     * the character to mask what the user types in the
     * RPasswordField.  It may be overridden in
     * {package}/PackageP.properties.
     */
    public static final String ECHO_CHAR = "PasswordField.echoChar";

    /** 
     * A resource <i>Field.topMargin</i> defined in
     * <TT>com.sgi.sysadm.ui.SysadmUIP.properties</TT> that specifies
     * the top margin to be used in Task TextFields.  This is the
     * amount of space between the top of the tallest letter, and the
     * border of the textfield.  It may be overridden in
     * {package}/packageP.properties, but please note that this
     * resource is shared with RTextField and ItemFinder.
     */
    public static final String TOP_MARGIN = "Field.topMargin";

    /** 
     * A resource <i>Field.bottomMargin</i> defined in
     * <TT>com.sgi.sysadm.ui.SysadmUIP.properties</TT> that specifies
     * the bottom margin to be used in Task TextFields.  This is the
     * amount of space between the bottom of a letter descender (ex.,
     * the tail of a "g"), and the border of the textfield.  It may be
     * overridden in
     * {package}/packageP.properties, but please note that this
     * resource is shared with RTextField and ItemFinder.
     */
    public static final String BOTTOM_MARGIN = "Field.bottomMargin";

    /** 
     * A resource <i>Field.leftMargin</i> defined in
     * <TT>com.sgi.sysadm.ui.SysadmUIP.properties</TT> that specifies
     * the left margin to be used in Task TextFields.  This is the
     * amount of space between the leftmost letter and the border of
     * the textfield.  It may be overridden in
     * {package}/packageP.properties, but please note that this
     * resource is shared with RTextField and ItemFinder.
     */
    public static final String LEFT_MARGIN = "Field.leftMargin";

    /** 
     * A resource <i>Field.rightMargin</i> defined in
     * <TT>com.sgi.sysadm.ui.SysadmUIP.properties</TT> that specifies
     * the right margin to be used in Task TextFields.  This is the
     * amount of space between the rightmost letter and the border of
     * the textfield.  It may be overridden in
     * {package}/packageP.properties, but please note that this
     * resource is shared with RTextField and ItemFinder.
     */
    public static final String RIGHT_MARGIN = "Field.rightMargin";

    private static Insets insets;
    private static Font font;
    private static char echoChar;

    static {
	// Static initializer
	ResourceStack rs = new ResourceStack();
	rs.pushBundle("com.sgi.sysadm.ui.SysadmUI" +
		       ResourceStack.BUNDLE_SUFFIX);
	font = rs.getFont(FONT);
	int left =  rs.getInt(LEFT_MARGIN);
	int right  = rs.getInt(RIGHT_MARGIN);
	int top  = rs.getInt(TOP_MARGIN);
	int bottom = rs.getInt(BOTTOM_MARGIN);
	insets = new Insets(top,left,bottom,right);
	echoChar = rs.getString(ECHO_CHAR).charAt(0);
    }
    /*
     * This is what makes the font monospace, and gives the textfield
     * a skosh more room (to match the size of JComboBoxes).
     */
    private void setUpCommonUI() {
        setFont(font);
        setEchoChar(echoChar);
        setMargin(insets);
    }

    /** 
     * Constructs a new RPasswordField.
     */
    public RPasswordField() {
	super();
	setUpCommonUI();
    }

    /** 
     * Constructs a new RPasswordField initialized with the spcified
     * <TT>text</TT>.
     * 
     * @param text The text to be displayed, or null.
     */
    public RPasswordField(String text) {
	super(text);
	setUpCommonUI();
    }

    /** 
     * Constructs a new RPasswordField with the
     * width set to the specified number of <TT>columns</TT>.
     * 
     * @param columns The width of the TextField in columns.
     */
    public RPasswordField(int columns) {
	super(columns);
	setUpCommonUI();
    }
    
    /** 
     * Constructs a new RPasswordField  with the
     * width set to the specified number of <TT>columns</TT> and initialized
     * with the specified <TT>text</TT>.
     * 
     * @param text The text to be displayed, or null.
     * @param columns The width of the TextField in columns.
     */
    public RPasswordField(String text, int columns) {
	super(text, columns);
	setUpCommonUI();
    }

    /** 
     * Constructs a new RPasswordField with the
     * width set to the specified number of <TT>columns</TT>, initialized
     * with the specified text and using the specified text storage
     * model.
     * 
     * @param text The text to be displayed, or null.
     * @param columns The width of the TextField in columns.
     * @param doc The text storage to use.
     */
    public RPasswordField(Document doc, String text, int columns) {
	super(doc, text, columns);
	setUpCommonUI();
    }
}
