//
// ResultViewFrame.java
//
//	A class that displays a ResultViewPanel in a JFrame
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

package com.sgi.sysadm.ui;

import javax.swing.*;
import com.sgi.sysadm.util.*;
import java.awt.*;  
import java.awt.event.*;
import com.sgi.sysadm.ui.event.*;

/** 
 * A class that displays a ResultViewPanel in a JFrame
 */
public class ResultViewFrame extends RFrame {
   
    /** 
     * A resource <I>"ResultViewFrame.okLabel</I> is a string that
     * specifies the text to be used in the OK button
     */
    public static final String OK = "ResultViewFrame.okLabel";
   
    /**
     * A resource <I>ResultViewFrame.vgap</I> is the size (in points)
     * of the gap to place between the bottom of the ResultViewPanel
     * and the OK button
     */
    public static final String VGAP = "ResultViewFrame.vgap";
    

    private ResultViewPanel _rvp;

    /**
     * Constructor
     *
     * @param rvp The ResultViewPanel to display
     * @param rs The resource stack to use to obtain resources for
     *           this ResultViewFrame.
     */
    public ResultViewFrame(ResultViewPanel rvp,
			   ResourceStack rs) {
	setDefaultCloseOperation(DISPOSE_ON_CLOSE);
	addWindowListener(new WindowAdapter() {
	    public void windowClosed(WindowEvent e) {
		if (_rvp != null) {
		    _rvp.destroy();
		}
	    }
	});
	_rvp = rvp;
	getContentPane().setLayout(new BorderLayout(0,rs.getPixels(VGAP)));
	getContentPane().add(rvp,BorderLayout.CENTER);
	JPanel buttonPanel = new JPanel();
	JButton button = new JButton(rs.getString(OK));
	buttonPanel.add(button);
	button.addActionListener(new ActionListener() {
	    public void actionPerformed(ActionEvent e) {
		dispose();
	    }
	});
	getContentPane().add(buttonPanel,BorderLayout.SOUTH);
    } 

    public void replacePanel(ResultViewPanel rvp) {
	getContentPane().remove(_rvp);
	getContentPane().add(rvp,BorderLayout.CENTER);
	_rvp.destroy();
	_rvp = rvp;
	validate();
    }
    
    /**
     * Launches a ResultViewFrame in a new window
     *
     * @param panel The ResultViewPanel to display
     * @param title The String to use as the ResultViewFrame title.
     * @param rs The resource stack to pass to the constructor of
     *           ResultViewFrame
     * @param uic The UIContext over which the busy cursor should be
     *            displayed while the ResultViewFrame is being launched.
     */
    public static void launchResultViewFrame(final ResultViewPanel panel,
					     String title,
					     ResourceStack rs,
					     final UIContext uic) {
        
        launchResultViewFrame(panel, title, rs, uic, null);
    }
    

    /**
     * Launches a ResultViewFrame in a new window
     *
     * @param panel The ResultViewPanel to display
     * @param title The String to use as the ResultViewFrame title.
     * @param rs The resource stack to pass to the constructor of
     *           ResultViewFrame
     * @param uic The UIContext over which the busy cursor should be
     *            displayed while the ResultViewFrame is being launched.
     * @param centerOver Center the frame over the panel given.
     */
    public static void launchResultViewFrame(final ResultViewPanel panel,
                                               String title,
                                               ResourceStack rs,
                                               final UIContext uic,
                                               final JPanel centerOver) {
	uic.busy();
	final HostContext hc = uic.getHostContext();
	String key = "ResultViewFrame";
	java.util.Vector vec = hc.getClients(key);
	if (vec.size() > 0) {
	    ResultViewFrame frame =
		(ResultViewFrame)
		    ((HostContext.Client)vec.elementAt(0)).getFrame();
	    frame.replacePanel(panel);
	    frame.setTitle(title);
	    frame.pack();
	    frame.toFront();
	    uic.notBusy();
	    return;
	}
	ResultViewFrame frame = new ResultViewFrame(panel,rs);
	final HostContext.Client resultViewClient =
	    new HostContext.Client(frame, new UIContext(panel));
	frame.setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
	frame.addWindowListener(new WindowAdapter() {
	    public void windowClosed(WindowEvent event) {
		hc.unregisterClient(resultViewClient);
	    }
	});
	frame.setTitle(title);
	frame.pack();
        if (centerOver != null) {
            Point p = centerOver.getLocationOnScreen();
            Dimension panelSize = centerOver.getSize();
            Dimension frameSize = frame.getSize();
            Point location = new Point(p.x + panelSize.width / 2 - 
                                       frameSize.width / 2,
                                       p.y + panelSize.height / 2 -
                                       frameSize.height / 2);
            
            frame.setLocation(location);
        }
	frame.setVisible(true);
	hc.registerClient(resultViewClient, key);
	uic.notBusy();    
    }
}
