//
//  TableCellComponentRenderer.java
//
//	A TableCellRenderer that can render a JComponent
//
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

package com.sgi.sysadm.ui;

import javax.swing.*;
import javax.swing.table.*;
import javax.swing.border.*;
import java.awt.*;

/**
 * A TableCellRenderer that can render a JComponent
 */
public class TableCellComponentRenderer implements TableCellRenderer {

    /**
     * @see javax.swing.table.TableCellRenderer#getTableCellRendererComponent(javax.swing.JTable, java.lang.Object, boolean, boolean, int, int)
     */
    public Component getTableCellRendererComponent(JTable table,
						   Object value,
						   boolean isSelected,
						   boolean hasFocus,
						   int row,
						   int column) {
	JComponent c = (JComponent)value;
	if (c == null || table == null || value == null ) {
	    return c;
	}
	if (isSelected) {
	    c.setBackground(table.getSelectionBackground());
	} else {
	    c.setBackground(table.getBackground());
	}
	if (hasFocus) {
	    c.setBorder( UIManager.getBorder(
		"Table.focusCellHighlightBorder") );
	    if (table.isCellEditable(row, column)) {
		c.setBackground( UIManager.getColor(
		    "Table.focusCellBackground") );
	    }
	} else {
	    // Make border match the DefaultCellRenderer's borders.
	    c.setBorder(new EmptyBorder(1, 2, 1, 2));
	}
	return c;
    }
}
