//
// TaskInitFailedException.java
//
//	Exception thrown when one of Task.setTaskDataAttr(),
//	Task.setOperands(), or Task.verifyPrereqs() fails.
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

package com.sgi.sysadm.ui;

/**
 * TaskInitFailedException is thrown when one of Task.setTaskDataAttr(),
 * Task.setOperands(), or Task.verifyPrereqs() fails.
 * <p>
 * Use getErrorCode() to determine what caused the exception.  Use
 * Exception.getMessage() to get a localized message suitable for
 * display to the user.
 */
public class TaskInitFailedException extends Exception {
    
    // Error codes are as follows:
    
    /**
     * Invalid data attribute key in Task.setDataAttr().
     */
    public static final int INVALID_DATA_ATTR = -1;
    
    /**
     * Invalid number of operands or illegal operand type.
     */
    public static final int INVALID_OPERANDS = -2;
    
    /**
     * Could not obtain privileges.  It is not usually necessary to display
     * the error message in this case because the user pressed cancel.
     */
    public static final int GET_PRIV_FAILED = -3;
    
    /**
     * System, data and/or operand(s) not in required state.
     */
    public static final int INVALID_PREREQS = -4;
    
    private int _errorCode;
    
    /**
     * Constructor.
     *
     * @param msg Localized error message suitable for display to users.
     * @param errorCode Code indicating what caused the exception.
     */
    public TaskInitFailedException(String msg, int errorCode) {
	super(msg);
	
	_errorCode = errorCode;
    }
    
    /**
     * Get the error code associated with this exception.
     *
     * @return Error code associated with this exception.
     */
    public int getErrorCode() {
	return _errorCode;
    }
}
