//
// TaskLaunchComponentState.java
//
//	A class that represents the state of an TaskLaunchComponent
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

package com.sgi.sysadm.ui; 

import com.sgi.sysadm.category.*;
import com.sgi.sysadm.util.*;

/**
 * A class that represents the state of an TaskLaunchComponent.
 * 
 * @see TaskLaunchComponent
 */
public class TaskLaunchComponentState {
    
    
    /**
     * The state that indicates that the Task has never been launched
     */
    public static final byte NEVER_LAUNCHED = 0;
    
    /**
     * The state that indicates that the Task has been launched, but
     * not yet canceled or completed.
     */
    public static final byte LAUNCHED = 1;

    /**
     * The state that indicates that the Task has been canceled
     */
    public static final byte CANCELED = 2;

    /**
     * The state that indicates that the Task has been sucessfully completed
     */
    public static final byte FINISHED = 3;
    
    private byte _state;
 
    /**
     * Construct a TaskLaunchComponentState
     *
     * @param state The state of the component
     */
    public TaskLaunchComponentState(byte state) {
	_state = state;
    }
   
    /**
     * Returns the state
     *
     * @return The state of the component.
     */
    public byte getTaskState() {
	return _state;
    }
}
