//
// ValueLabel.java
//
//      A subclass of RLabel that uses a standard font.
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

package com.sgi.sysadm.ui;

import com.sgi.sysadm.util.*;

/**
 * This class can be used wherever a JLabel would be used,
 * but where a standardized look is desired.  It is designed for use
 * for labels that are used for values, (eg. in the right-hand column
 * of a Task.)
 */

public class ValueLabel extends RLabel {
    
    /**
     * The string "ValueLabel" that will be used for all resource
     * lookups for this component.
     */
    public static final String NAME = "ValueLabel";

    /**
     * Creates a ValueLabel with the specified text
     *
     * @param text The text to display in the label.
     * @param rs The resource stack to use to look up resources.
     */
    public ValueLabel(String text, ResourceStack rs) {
	super(text, rs, NAME);
    }

    /**
     * Creates a ValueLabel with no text.  You can use setText at a
     * later time to set the text.
     *
     * @param rs The resource stack to use to look up resources.
     */
    public ValueLabel(ResourceStack rs) {
	super(rs, NAME);
    }
}
    

