//
// ItemViewLaunchRequestEvent
//   
//	An event describing a request to launch a task
//
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

package com.sgi.sysadm.ui.event;

import java.util.*;

/**
 * An object that specifies an ItemView.  From the data contained in
 * this object, an ItemViewLaunchRequestListener can
 * create an ItemView of the type that the <tt>source</tt> is
 * requesting be launched.
 * <p>
 * See the ItemViewLaunchRequestListener documentation about how this
 * event is used.
 *
 * @see ItemViewLaunchRequestListener
 * @see ItemView
 */
public class ItemViewLaunchRequestEvent extends EventObject {
    
    private String _categorySelector;
    private String _itemSelector;
    
    /** 
     * A constructor that takes the selectors of Category and Item of
     * the ItemView to launch.
     *
     * @param source The source of this event
     * @param categorySelector The selector of the Category containing
     *                         the Item of interest
     * @param itemSelector The selector of the Item of interest
     */
    public ItemViewLaunchRequestEvent(Object source, 
				      String categorySelector,
				      String itemSelector) {
	super(source);
	_categorySelector = categorySelector;
	_itemSelector = itemSelector;
    }
    
    /** 
     * Returns the selector of the Category for which to launch an
     * ItemView.
     *
     * @return The Selector of the Category
     */
    public String getCategorySelector() {
	return _categorySelector;
    }
    
    /**
     * Returns the Item's selector for which to launch an ItemView.
     *
     * @return The Selector of the Item
     */
    public String getItemSelector() {
	return _itemSelector;
    }
}
