//
// TableSortRequestEvent.java
//   
//	An event describing a request to sort a table
//
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//
package com.sgi.sysadm.ui.event;

import com.sgi.sysadm.category.*;
import java.util.*;
import java.awt.*;

/**
 * This class represents an event describing a request to sort a table
 * based on a particular column.
 */
public class TableSortRequestEvent extends EventObject {
    private int _column;
    private int _modifiers;
    
    /** 
     * A constructor that takes the column to sort on and modifiers
     * that were being held down.
     *
     * @param source The source of this event
     * @param column The column (relative to the model) to sort on
     * @param modifiers Flags representing the modifier keys that
     *                  were being held down
     */
    public TableSortRequestEvent(Object source, 
				 int column,
				 int modifiers) {
	super(source);
	_column = column;
	_modifiers = modifiers;
    }

    /**
     * Returns the column to sort on
     * @return The column relative to the model
     */
    public int getColumn() {
	return _column;
    }

    /**
     * Returns the modifiers flag for this event.
     * @return the modifiers
     */
    public int getModifiers() {
        return _modifiers;
    }

    /**
     * Returns whether or not the Shift modifier was down on this
     * event.
     * 
     * @return true if shift was down, else false.
     */
    public boolean isShiftDown() {
        return (_modifiers & Event.SHIFT_MASK) != 0;
    }

    /**
     * Returns whether or not the Control modifier was down on this event.
     * 
     * @return true if control was down, else false.
     */
    public boolean isControlDown() {
        return (_modifiers & Event.CTRL_MASK) != 0;
    }

    /**
     * Returns whether or not the Meta modifier was down on this event.
     * 
     * @return true if meta was down, else false
     */ 
    public boolean isMetaDown() {
        return (_modifiers & Event.META_MASK) != 0;
    }

    /**
     * Returns whether or not the Alt modifier was down on this event.
     * 
     * @return true if alt was down, else false
     */ 
    public boolean isAltDown() {
        return (_modifiers & Event.ALT_MASK) != 0;
    }
}
