//
// TaskLaunchRequestListener
//   
//	Used to listen for user's requests to lauch a task
//
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

package com.sgi.sysadm.ui.event;
import java.util.EventListener;

/**
 * TaskLaunchRequestListener is an interface for clients that want to
 * know when a user has requested that an Task be launched.  It
 * is used for UI components that want to let another class deal with
 * the details of how to launch the Task.  
 * <p>
 * For example, there
 * could be a component that contains a button that launches an Task,
 * but the manner in which the Task should be displayed (in a
 * new frame, embedded in another frame, etc) is not known to
 * the component.  Some higher level code that knew how to launch the
 * Task could add an TaskLaunchRequestListener to the
 * component, and handle the launch of the Task in the
 * appropriate manner.
 *
 * @see Task
 */
public interface TaskLaunchRequestListener extends EventListener {

    /** 
     * A request to launch a Task.
     * @param event The TaskLaunchRequestEvent that specifies which
     *              Taskthe user requested be launched.
     */
    public void taskLaunchRequested(TaskLaunchRequestEvent event);
}
