//
// TitleEvent.java
//
//	An event containing a new title.
//	
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

package com.sgi.sysadm.ui.event;

import com.sgi.sysadm.ui.*;
import java.awt.*;

/**
 * TitleEvent is sent to TitleListeners to indicate that
 * the title has been set or modified.
 */
public class TitleEvent extends java.util.EventObject {
    private String _title;
    
    /**
     * Constructor.
     *
     * @param source The UI Component whose title has been set or modified.
     * @param title The new or modified task title.
     */
    public TitleEvent(Component source, String title) {
	super(source);
	_title = title;
    }
   
    /**
     * Get the new or modified title.
     *
     * @return The new or modified title.
     */
    public String getTitle() {
	return _title;
    }
}
