//
// CompoundWord.java
//
//	A Word that consists of other Words.
//
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

package com.sgi.sysadm.ui.richText;

import java.util.*;

/**
 * CompoundWord represents a word that contains font changes.  Since
 * each SingleWord only knows how to draw in one font, a word with
 * font changes must be made up of more than one Single word.  Having
 * an Word subclass for this situation simplifies Paragraph's logic.
 */
class CompoundWord extends Word {

    Vector _words = new Vector();

    /**
     * Add a word to our list of words.
     * 
     * @param word The word to add.
     */
    void addWord(Word word) {
	_words.addElement(word);
    }

    /**
     * Calculate the width this word should have.  Set geometry
     * parameters accordingly.
     * 
     * @param state Graphics state.
     * @param x left edge.
     * @param y top edge.
     * @param height The height we should have.
     */
    void setGeometry(GraphicsState state, int x, int y, int height) {
	_x = x;
	_y = y;
	_height = height;

	_width = 0;
	final int size = _words.size();
	for (int ii = 0; ii < size; ii++) {
	    Word word = (Word)_words.elementAt(ii);
	    word.setGeometry(state, x, y, height);
	    x += word.getWidth();
	    _width += word.getWidth();
	}
    }

    /**
     * Draw our words.
     * 
     * @param state Graphics state.
     */
    void draw(GraphicsState state) {
	final int size = _words.size();
	for (int ii = 0; ii < size; ii++) {
	    ((Word)_words.elementAt(ii)).draw(state);
	}
    }
}
