//
// FontChange.java
//
//	Switch fonts during drawing.
//
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

package com.sgi.sysadm.ui.richText;

import com.sgi.sysadm.util.*;
import java.awt.*;

/**
 * FontChange objects change state._font when their setGeometry() and
 * draw() methods are called.  This affects geometry calculations and
 * rendering of other Word objects that follow.
 */
class FontChange extends Word {
    
    private Font _font;

    FontChange(Font font) {
	Log.assert(font != null,
		   "FontChange with a null font");
	_font = font;
    }

    /**
     * Set our geometry.  FontChange objects have no width.  We switch
     * fonts so that other elements in the scene graph can use the
     * right font for setting their geometry.
     * 
     * @param state Graphics parameters.
     * @param x left edge.
     * @param y top edge.
     * @param height height.
     */
    void setGeometry(GraphicsState state, int x, int y, int height) {
	_x = x;
	_y = y;
	_width = 0;
	_height = height;

	state._font = _font;
	state._fontMetrics = state._graphics.getFontMetrics(_font);
    }

    /**
     * Change fonts during drawing.
     * 
     * @param state Graphics parameters.
     */
    void draw(GraphicsState state) {
	state._font = _font;
	state._fontMetrics = state._graphics.getFontMetrics(_font);
	state._graphics.setFont(_font);
    }
}
